<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2020',
    'hashtag' => "#enmi20",
    'abstract' => "<b>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>22 et 23 décembre 2020</em>", 

    'description' => "<h3>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</h3>
    <p>Paris. Centre Pompidou. Grande Salle.<br>
    22 et 23 décembre 2020<br>
    <a href=\"https://enmi-conf.org/wp/enmi20\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>La notion d’information, qui n’avait alors jamais été mobilisée dans l’histoire de la philosophie , est apparue dans le champ théorique à la suite de
    plusieurs événements scientifiques : la publication de la théorie de la communication de Shannon en 1948, la mécanisation de certains calculs avec la 
    première implémentation d’une machine équivalente à celle de Turing (ENIAC) en 1945, et la découverte de la structure de l’ADN en 1953. En 1962, cette 
    notion fait l’objet du colloque de Royaumont consacré à la cybernétique . En 1970, elle est mobilisée dans La logique du vivant , qui pose la question de 
    l’information génétique. Dans les années 1980, elle nourrit les sciences cognitives et le computationnalisme, qui considèrent la pensée comme un processus 
    de traitement de l’information pouvant être implémenté dans une structure électronique.</p>
    <br>
    <p>L’information devient ainsi le fondement d’une conception mécaniste du vivant, qui réduit la vie biologique (l’organisme) à des mécanismes et d’une 
    conception cognitiviste de la pensée, qui réduit la vie noétique (l’esprit) à la cognition. La première conduit à des volontés de maîtrise et de 
    transformation du fonctionnement des êtres vivants, qui ont de nombreuses conséquences problématiques, des OGM à la santé environnementale. La seconde 
    engendre des volontés de contrôle des pensées et des cerveaux, qui se manifestent par les projets transhumanistes de téléchargement de l’esprit ou 
    d’implants cérébraux, mais aussi et d’abord par les « applications », pour smartphone notamment, dont le design a pour objectif de capturer et d’exploiter 
    l’attention des individus psychiques.</p>
    <br>
    <p>En effet, l’information n’est pas seulement un concept opératoire au fondement des technosciences contemporaines : elle est aussi une réalité technique 
    et sociale qui ne cesse de se concrétiser, et de transformer en profondeur les rapports intergénérationnels qui constituent les sociétés. Dès 1944, alors 
    que les industries culturelles audiovisuelles commencent à se développer, Theodor Adorno et Max Horkheimer dénoncent « la marée de l'information précise et 
    d'amusements domestiqués » qui abêtit les hommes et envahit leurs vies quotidiennes. En 1979, alors que se poursuit « l’informatisation de la société », 
    Jean-François Lyotard déplore la transformation du savoir en « marchandise informationnelle » : les savoirs ne sont plus pratiqués collectivement mais 
    « extériorisés par rapport aux sachants » et réduits à leur valeur d’échange, par ce qui sera ensuite décrit comme un « capitalisme cognitif ». Une 
    trentaine d’années plus tard, Bernard Stiegler ne dira pas autre chose en décrivant le capitalisme computationnel comme une « anti-épistémè » : à l’époque 
    de l’intelligence artificielle réticulée, tous les savoirs (faire, vivre et penser), autrement dit, tous les échanges en quoi consiste la vie psychique et 
    sociale, sont soumis aux calculs et aux marchés, après avoir été transformés en données à travers les instruments de statistique, de mesure, de 
    quantification et de logistique que constituent les algorithmes.</p>
    <br>
    
    <p>Cette « digitalisation généralisée », qui correspond à une marchandisation de toutes les sphères de l’existence, ne cesse néanmoins de révéler son 
    caractère pharmacologique : si l’apparition du web avait pu engendrer un certain nombre d’espoirs quant au renversement des pouvoirs 
    « télé-techno-médiatiques », voire l’émergence de nouvelles utopies, l’avènement des réseaux sociaux, combinés aux smartphones et aux applications et 
    contrôlés par quelques plateformes planétaires, ont mis fin aux rêves de décentralisation, de partage du savoir et de  démocratisation  : ce sont au 
    contraire des « sociétés de contrôle » qui semblent s’être progressivement instaurées, dominées par des médias sociaux mémétiques, dont la toxicité en 
    terme d’« écologie mentale » est désormais prouvée et dont les enjeux politiques n’ont pas fini de se manifester. Soumises au marketing et à la publicité, 
    fondées sur la logique de l’audience, du buzz et du marché, les industries culturelles numériques poursuivent ainsi la destruction des relations entre 
    générations que l’avènement de la télévision avait considérablement aggravé . Cette destruction s’opère à travers la « disruption » les différents types 
    de savoirs qui composent et consolident ces relations : depuis les savoirs éducatifs menacés par la surexposition des jeunes enfants aux écrans et la 
    captation toujours plus performante de l’attention des adolescents par les plateformes, jusqu’aux savoirs médicaux et scientifiques réduits à des quantités 
    massives de données et leur traitement automatique , en passant par les différents types de savoirs vivre, exister et habiter, que la « smartification » 
    des environnements urbains semble menacer.</p>
    <br>
    
    <p>A l’heure du « screen new deal », qui correspond à une extension sans précédent du télé-travail et du télé-enseignement, il semble plus que jamais 
    nécessaire de transformer le fonctionnement des « télétechnologies » informatiques et numériques, pour éviter ces effets de « prolétarisation généralisée », 
    qui menacent la vie politique et accélèrent la catastrophe écologique. Une telle tâche suppose néanmoins de repenser les modèles théoriques et économiques 
    qui sont au fondement du fonctionnement de ces technologies. </p>
    <br>

    <p>Les modèles informationnels et computationnels de la vie biologique et noétique qui se sont imposés n’ont rien de nécessaires. Bien au contraire : une 
    contre-histoire reste à écrire, montrant que les premiers spécialistes de la cybernétique se méfiaient de l’analogie entre machine et organisme et qu’Alan 
    Turing lui-même n’aurait jamais osé comparer l’intelligence à un traitement de données. Dans le champ de la philosophie elle-même, de Bergson à Canguilhem, 
    en passant par Lotka, Popper, Leroi-Gourhan et Simondon, une pensée de l’extériorisation technique a vu le jour, qui permet de dépasser les analogies entre 
    machine et organisme comme entre ordinateur, cerveau et pensée. La machine ou l’ordinateur, produits par des vivants pensants et s’individuant 
    collectivement, ne peuvent servir de modèles pour saisir le « fonctionnement » de ces mêmes vivants : ils ne constituent pas des modèles, mais des organes 
    artificiels, c’est-à-dire, des supports dans lesquels s’extériorisent des fonctions motrices ou noétiques, fonctions qui évoluent donc avec les systèmes 
    d’écritures et de calculs mécaniques, automatiques, analogiques, puis numériques. C’est cette co-évolution entre fonctions noétiques et organes 
    exosomatiques que Bernard Stiegler décrivait comme une « exorganogenèse de la noèse », et qui devait selon lui constituer la base d’une « nouvelle 
    informatique théorique ». </p>
    <br>

    <p>Nous tenterons durant ces deux jours d’explorer cette voie, à la fois du point de vue de ses enjeux théoriques (1) et de ses enjeux pratiques et 
    politiques (2).</p>
    <br>

    <p>(1) En quoi la prise en compte du processus d’exosomatisation permet-elle de dépasser le paradigme de l’information, et implique-t-elle de repenser 
    jusqu’à la notion même d’intelligence artificielle ? Comment transformer l’objet de l’interrogation théorique, afin de ne plus se focaliser sur la machine 
    elle-même, et sur ses potentielles performances computationnelles, mais d’envisager son couplage avec les individus psychiques au sein d’organisations 
    sociales, économiques et politiques ?  En quoi cette étude des rapports entre organismes psycho-somatiques, organes techniques et organisations sociales 
    permet-elle de renouveler les conceptions de la vie, de la technique et de l’esprit ?</p>
    <br>

    <p>(2) Comment cette nouvelle approche « organologique » se traduit-elle en termes de conceptions et de développements technologiques ? Comment réaliser 
    des dispositifs numériques prenant soin des relations sociales et des fonctions noétiques, en particulier celles des nouvelles générations ? Les 
    technologies numériques peuvent-elles devenir autre chose que des puissances de calculs ? Peuvent-elles favoriser la délibération collective, le partage 
    des savoirs et la réactivation des significations transgénérationnelles, plutôt que l’économie des données et le capitalisme computationnel ?</p>
    
    </p>
    <br>
    <h3>Programme initial</h3>
    <h4><strong>ATTENTION ceci est une version de travail à confirmer.</strong></h4>
    <br>
    <p><strong>Mardi 22 décembre&nbsp;: Repenser l’informatique théorique</strong></p>
    </br>
    <p><strong>09h30-12h30 - Session 1 : Vers une nouvelle informatique théorique : de l’information à l’exosomatisation, enjeux philosophiques, économiques et politiques</strong></p>
    <ul>
    <li><p><strong>09h30 : David Bates (philosophie politique et épistémologie, histoire de l’IA, Berkeley University)</strong></p></li>
    <li><p><strong>10h15 : Daniel Ross (philosophie politique, Institut de Recherches et d’Innovation ?)</strong></p></li>
    <li><p><strong>11h00 : Mathieu Triclot (philosophie, Université de technologie de Belfort-Montbéliard)</strong></p></li>
    <li><p><strong>11h45 : Anne Alombert (philosophie, Université Catholique de Lille)</strong></p></li>
    <li><p><strong>12h30 : Discussion</strong></p></li>
    <li><p><strong>13h00 : Pause</strong></p></li>
    </ul>
    <br>
    <p><strong>14h00 : 16h30 - Session 2 : Information et signification, de la vie endosomatique à la vie exosomatique : entre calcul et incalculable, entre biologie et informatique</strong></p>
    <ul> 
    <li><p><strong>14h00 : Maël Montévil (biologie théorique et épistémologie, IRI et IHPST, Université paris 1)</strong></p></li>
    <li><p><strong>14h30 : Giuseppe Longo (mathématiques et épistémologie, CNRS et ENS, )</strong></p></li>
    <li><p><strong>15h00 : Yuk Hui (informatique, philosophie de la technique, Hong Kong University ?)</strong></p></li>
    <li><p><strong>15h30 : Jean Lassègue (anthropologie philosophique, CNRS LIAS)</strong></p></li>
    <li><p><strong>16h00 : Discussion</strong></p></li>
    </ul>
    <br>
    <p><strong>17h00 : 19h30 - Session 3 : Technologies de la langue, programmes musicaux et langages informatiques : des données calculables aux improvisations interprétatives</strong></p>
    <ul>
    <li><p><strong>17h00 : Roberto Di Cosmo (informatique fondamentale et appliquée, Université Paris Diderot)</strong></p></li>
    <li><p><strong>17h25 : Frédéric Kaplan (informatique et linguistique, Ecole Polytechnique Fédérale de Lausanne)</strong></p></li>
    <li><p><strong>17h50 : Michal Krzykawski (philosophie, Université de Silésie à Katowice)</strong></p></li>
    <li><p><strong>18h15 : Bruno Bachimont (philosophie des techniques, Sorbonne Université)</strong></p></li>
    <li><p><strong>18h40 : Gerard Assayag (musicologie et informatique, IRCAM)</strong></p></li>
    <li><p><strong>19h05 : Discussion</strong>
    </ul>
    <br>
    <br>
    <p><strong>Mercredi 23 décembre&nbsp;: Renouer les technologies et les générations</strong></p>
    <br>
    <p><strong>09h30 : 12h30 - Session 4 : L’individuation psychique et collective dans les milieux digitaux : données et profils, addictions et attentions</strong></p>
    <ul>
    <li><p><strong>09h30 : Susanna Lindberg (philosophie et philosophie de la technique, Leiden University)</strong></p></li>
    <li><p><strong>10h00 : Gerald Moore (philosophie et anthropologie, Durham University)</strong></p></li>
    <li><p><strong>10h30 : Simon Woillet (philosophie et psychanalyse, Université Paris 3)</strong></p></li>
    <li><p><strong>11h00 : Marie-Claude Bossière (pédopsychiatrie)</strong></p></li>
    <li><p><strong>11h30 : Discussion</strong></p></li>
    <li><p><strong>12h30 : Pause</strong></p></li>
    </ul>
    <br>
    <p><strong>14h00 : 16h30 - Session 5 : Éducations et capacitation dans l'ère post-véridique : technologies numériques, médias sociaux et savoirs transgénérationnels</strong></p>
    <ul> 
    <li><p><strong>14h00 : Victor Chaix (étudiant et activiste, Institut de Recherche et d’Innovation et Association des amis de la génération Thunberg)</strong></p></li>
    <li><p><strong>14h30 : Maxime Barillaud (enseignement et référent numérique, Collège Poincaré)</strong></p></li>
    <li><p><strong>14h55 : Bruno Patino (journalisme, Arte France)</strong></p></li>
    <li><p><strong>15h20 : Yves Citton (littérature et média, Université Paris 8)</strong></p></li>
    <li><p><strong>15h45 : Franck Cormerais (sciences de l’information et de la communication, Université Bordeaux Montaigne)</strong></p></li>
    <li><p><strong>16h10 : Discussion</strong></p></li>
    </ul>
    <br>
    <p><strong>16h00 : 18h00 - Session 6 : Recherche et design dans les milieux digitaux : des programmes aux bifurcations</strong></p>
    <ul>
    <li><p><strong>16h00 : Tallulah Frappier (design d’interaction et plateformes de délibérations, ENS Cachan)</strong></p></li>
    <li><p><strong>16h25 : Anthony Masure (philosophie et design, Université Toulouse - Jean Jaurès)</strong></p></li>
    <li><p><strong>16h50 : Samuel Huron (design et design d’information, Télécom Paris)</strong></p></li>
    <li><p><strong>17h15 : Sébastien Massart (directeur de la stratégie de Dassault Systèmes)</strong></p></li>
    <li><p><strong>17h40 : Noël Fitzpatrick (digital studies network, Université Technologique de Dublin)</strong></p></li>
    <li><p><strong>18h05 : Discussion</strong></p></li>
    </ul>",

    'link' => "https://enmi-conf.org/wp/enmi20/",
    'islive' => false,
    'islive_embed' => "",
    'keywords' => "Informatique, générations, ENMI, Centre Pompidou, soin",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 22 et 23 décembre 2020',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    // 'semantic_board' => true,
    // 'js_config' => "
    //     tracking_keywords = [ '#enmi18' ],
    //     suggested_keywords = []
    // ",
);
