# set base image (host OS)
FROM docker.io/python:2.7-alpine as builder

ENV VIRTUALENV=/opt/venv

# set the working directory in the container
WORKDIR /code

RUN \
    pip install virtualenv && \
    virtualenv $VIRTUALENV

ENV PATH="$VIRTUALENV/bin:$PATH"

# copy the dependencies file to the working directory
COPY docker/server/requirements.txt .

ENV JCC_JDK=/usr/lib/jvm/java-11-openjdk
ENV JCC_LFLAGS="-L/usr/lib/jvm/java-11-openjdk/jre/lib -ljava -L/usr/lib/jvm/java-11-openjdk/jre/lib/server -ljvm"
ENV PATH="/usr/lib/jvm/java-11-openjdk/jre/bin:$PATH"
ENV LD_LIBRARY_PATH="/usr/lib/jvm/java-11-openjdk/jre/lib:/usr/lib/jvm/java-11-openjdk/jre/lib/server"
# ENV JCC_LFLAGS=-L/usr/lib/jvm/java-8-openjdk/jre/lib/amd64


RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt libmemcached openjdk11 apache-ant bash jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
 apk add --no-cache --virtual .build-deps build-base postgresql-dev libxml2-dev libxslt-dev linux-headers sed wget patchelf git jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev && \
 wget https://dlcdn.apache.org/lucene/pylucene/pylucene-7.7.1-src.tar.gz && \
 tar zxvf pylucene-7.7.1-src.tar.gz && \
 cd pylucene-7.7.1 && \
 cd jcc && \
 python setup.py install && \
 cd .. && \
 sed -i '1s/^/PREFIX_PYTHON=\/opt\/venv\nANT=JAVA_HOME=\/usr\/lib\/jvm\/java-11-openjdk \/usr\/bin\/ant\nPYTHON=$(PREFIX_PYTHON)\/bin\/python\nJCC=$(PYTHON) -m jcc --shared\nNUM_FILES=8\n/' Makefile && \
 sed -i 's/http:\/\/repo1\.maven\.org\/maven2/https:\/\/repo1.maven.org\/maven2/' lucene-java-7.7.1/lucene/common-build.xml && \
 patchelf --add-needed libjvm.so /opt/venv/lib/python2.7/site-packages/JCC-3.5-py2.7-linux-x86_64.egg/jcc/_jcc2.so && \
 patchelf --add-needed libjvm.so /opt/venv/lib/python2.7/site-packages/JCC-3.5-py2.7-linux-x86_64.egg/libjcc2.so && \
 make && \
 make install && \
 cd /code && \
 wget https://hg.dev.iri-research.org/platform/archive/V01.11.tar.gz && \
 tar zxvf V01.11.tar.gz && \
 cd platform-V01.11/src/ldt && \
 python setup.py sdist && \
 pip install dist/ldt-1.11.tar.gz && \
 cd /code && \
 pip install -r requirements.txt


FROM docker.io/python:2.7-alpine 

COPY --from=builder /opt/venv /opt/venv
COPY web/tralalere /code/tralalere
COPY web/manage.py /code/



ENV BASEDIR="/code"
ENV PATH="/opt/venv/bin:$BASEDIR:$PATH"

WORKDIR $BASEDIR

RUN \
  apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt libmemcached openjdk11 apache-ant bash jpeg-dev zlib-dev freetype-dev lcms2-dev openjpeg-dev tiff-dev tk-dev tcl-dev bash && \
  mkdir -p /static


COPY docker/server/config.py ./tralalere/

COPY docker/server/tralalere.yml .
COPY --chmod=0755 docker/server/entrypoint.sh /

ENV PYTHONPATH "/code/"
ENV DJANGO_SETTINGS_MODULE tralalere.settings
ENV DEBUG "False"
ENV DATABASE_URL ""
ENV DJANGO_SECRET ""

ENV PATH="/usr/lib/jvm/java-11-openjdk/jre/bin:$PATH"
ENV LD_LIBRARY_PATH="/usr/lib/jvm/java-11-openjdk/jre/lib:/usr/lib/jvm/java-11-openjdk/jre/lib/server"

EXPOSE 8000

ENTRYPOINT ["/entrypoint.sh"]

# # command to run on container start
CMD [ "/opt/venv/bin/uwsgi", "--yaml", "/code/tralalere.yml"]