
from django.shortcuts import render_to_response
from django.template import RequestContext
from ldt.ldt_utils.models import Content, Segment
import math
import operator

COLORS = ['red', 'yellow', 'green', 'blue']
EMOTICONS = ['happy','unhappy','laughing','surprised']



def home(request):
    
    contents = Content.objects.filter(front_project__state = 2)
    
    tags_stats = {}
    nb_segments = 0
    for segment in Segment.objects.filter(content__in = contents):
        nb_segments += 1
        c_tags = tags_stats.setdefault(segment.iri_id,{})
        
        for t in segment.tags.split(";"):
            t = t.strip().lower()
            if t:
                c_tags[t] = c_tags.setdefault(t,0) + 1
            if t in COLORS:
                c_tags['colors'] = c_tags.setdefault('colors',0) + 1
            if t in EMOTICONS:
                c_tags['emoticons'] = c_tags.setdefault('emoticons',0) + 1
    tags = {}
     
    for contentid, c_tags in tags_stats.iteritems():
        emoticons_stats = []
        tag_max = 0.0
        tag_sum = 0.0
        
        for t in EMOTICONS:
            if t in c_tags:
                tag_sqrt = math.sqrt(c_tags[t])
                tag_max = max(tag_max, tag_sqrt)
                tag_sum += tag_sqrt
        if tag_max:
            tag_factor = 1.0 / tag_max
            if tag_sum * tag_factor > 2.8:
                tag_factor = tag_factor * 2.8 / ( tag_sum * tag_factor )
                
            for t in EMOTICONS:
                if t in c_tags:
                    score = c_tags[t]
                    tag_sqrt = math.sqrt(score)
                    scale = tag_sqrt * tag_factor
                    width = int(50*scale)
                    emoticons_stats.append({'tag':t, 'score': score, 'scale': scale, 'width':width})
                    
        emoticons_stats.sort(key=operator.itemgetter('score','tag'), reverse=True)

        colors_stats = []
        tag_max = 0.0
        tag_sum = 0.0

        for t in COLORS:
            if t in c_tags:
                tag_sqrt = math.sqrt(c_tags[t])
                tag_max = max(tag_max, tag_sqrt)
                tag_sum += tag_sqrt
        if tag_max:
            tag_factor = 1.0 / tag_max
            if tag_sum * tag_factor > 2.8:
                tag_factor = tag_factor * 2.8 / ( tag_sum * tag_factor )
                
            for t in COLORS:
                if t in c_tags:
                    score = c_tags[t]
                    tag_sqrt = math.sqrt(score)
                    scale = tag_sqrt * tag_factor
                    width = int(50*scale)
                    colors_stats.append({'tag':t, 'score': score, 'scale': scale, 'width':width})
                    
        colors_stats.sort(key=operator.itemgetter('score','tag'), reverse=True)


        
        tags[contentid] = {'emoticons': emoticons_stats, 'colors': colors_stats}
        
    contents_list = []
    for content in contents:
        if content.iri_id in tags:
            tags_stats = tags[content.iri_id]
        else:
            tags_stats = None
        content.tags_stats = tags_stats
        contents_list.append(content)
    return render_to_response('home.html', {'contents': contents_list}, context_instance=RequestContext(request))


def player(request, contentid):
    
    content = Content.objects.get_by_natural_key(contentid)
    
    return render_to_response('player.html', {'content': content}, context_instance=RequestContext(request))