"""
WSGI config for tralalere project.

This module contains the WSGI application used by Django's development server
and any production WSGI deployments. It should expose a module-level variable
named ``application``. Django's ``runserver`` and ``runfcgi`` commands discover
this application via the ``WSGI_APPLICATION`` setting.

Usually you will have the standard Django WSGI application here, but it also
might make sense to replace the whole Django WSGI application with a custom one
that later delegates to the Django one. For example, you could introduce WSGI
middleware here, or combine a Django application with an application of another
framework.

"""
import os, sys, site

global g_env_set

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "tralalere.settings")

def application(environ, start_response):
    
    if 'g_env_set' not in globals() or not g_env_set:
        environ['PYDEV_DEBUG'] = environ.get('PYDEV_DEBUG', "False").lower() in ["true", "1", "t"]
        g_env_set = True


    # This application object is used by any WSGI server configured to use this
    # file. This includes Django's development server, if the WSGI_APPLICATION
    # setting points here.
    from django.core.wsgi import get_wsgi_application
    _application = get_wsgi_application()
    
    if environ.get('PYDEV_DEBUG', False):
        import pydevd #@UnresolvedImport
        pydevd.settrace(suspend=False)


    return _application(environ, start_response)
        

# Apply WSGI middleware here.
# from helloworld.wsgi import HelloWorldApplication
# application = HelloWorldApplication(application)
