﻿package  {
	
	import flash.display.MovieClip;
	
	import flash.text.TextField;
	import flash.display.Sprite;
	import flash.system.Security;
	import flash.events.MouseEvent;
	import flash.net.NetConnection;
	import flash.events.NetStatusEvent;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.AsyncErrorEvent;
	import flash.events.ErrorEvent;
	import flash.media.Microphone;
	import flash.net.NetStream;
	import flash.utils.getTimer;
	
	public class record_mic extends MovieClip {
		
		private var t:TextField;
		private var r:Sprite;
		private var s:Sprite;
		private var p:Sprite;
		
		private var urlServer:String = "rtmp://media.iri.centrepompidou.fr/ddc_micro_record";
		private var nc:NetConnection;
		private var ns:NetStream;
		private var ns2:NetStream;
		private var mic:Microphone;
		private var filename:String;
		private var recordStopped:Boolean = false;
		
		public function record_mic() {
			// constructor code
			Security.allowDomain("*");
			Security.allowInsecureDomain("*");
			
			t = _t;
			r = _recordBtn;
			s = _stopBtn;
			p = _playBtn;
			trace("t = " + t + ", r = " + r + ", s = " + s + ", p = " + p);
			
			r.buttonMode = r.useHandCursor = s.buttonMode = s.useHandCursor = p.buttonMode = p.useHandCursor = true;
			r.addEventListener(MouseEvent.CLICK, startRecord);
			s.addEventListener(MouseEvent.CLICK, stopRecord);
			p.addEventListener(MouseEvent.CLICK, playRecord);
		}
		private function startRecord(e:MouseEvent=null):void{
			trace("startRecord nc = " + nc);
			if (nc==null){
				trace("  startRecord 2");
				nc = new NetConnection();
				nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler, false, 0, true);
				nc.addEventListener(IOErrorEvent.IO_ERROR, errorHandler, false, 0, true);
				nc.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler, false, 0, true);
				nc.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler, false, 0, true);    	
				nc.connect(urlServer);
			}
			else{
				publish();
			}
		}
		private function errorHandler(e:*=null):void {
			trace("errorHandler");
        	closeStream();
        }
		private function closeStream():void{
			trace("closeStream");
			if(ns!=null){
				trace("  ns.close()");
        		ns.close();
        		ns = null;
			}
		}
		private function netStatusHandler(event:NetStatusEvent):void {
			trace("netStatusHandler : " + event.info.code);
        	switch (event.info.code) {
	        	case 'NetConnection.Connect.Success':
					publish();
	        		break;
	        	case 'NetConnection.Connect.Failed':
	        	case 'NetConnection.Connect.Reject':
	        	case 'NetConnection.Connect.Closed':
	        		//closeStream();
	        		break;
        	}
        }
		// send data over rtmp
		private function publish():void {
			trace("publish (ns==null && nc!=null && nc.connected) = " + (ns==null && nc!=null && nc.connected));
			if(nc!=null && nc.connected) {
				trace("  publish 2");
				ns = new NetStream(nc);
				ns.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler, false, 0, true);
				ns.addEventListener(IOErrorEvent.IO_ERROR, errorHandler, false, 0, true);
				ns.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler, false, 0, true);
				// informs the server to record what it receives
				// in fact file name is passed as the user name (the server is meant to record everything it has to in a file named from the user name)	
				filename = "r_" + now();
				trace("filename = " + filename);
				ns.publish(filename, 'record');
				mic = Microphone.getMicrophone(-1);
				mic.rate = 22;
				mic.gain = 50;
				mic.setUseEchoSuppression(true);
				ns.attachAudio(mic);
			}
		}
		// stop the recording of audio to the stream
		private function stopRecord(e:*=null):void{
			trace("stopRecord (ns!=null) = " + (ns!=null));
			if(ns!=null){
				trace("  stopRecord 2");
				recordStopped = true;
				ns.play(false); // flushes the recording buffer
    			ns.close();
			}
		}
		// plays back the audio that was recorded
		private function playRecord(e:*=null):void{
			trace("playRecord (ns!=null && recordStopped) = " + (ns!=null && recordStopped));
			if(recordStopped){
				trace("  playRecord 2");
				ns2 = new NetStream(nc);
				ns2.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler2, false, 0, true);
				ns2.addEventListener(IOErrorEvent.IO_ERROR, errorHandler2, false, 0, true);
				ns2.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler2, false, 0, true);
				ns2.play(filename);
			}
		}
		private function netStatusHandler2(event:NetStatusEvent):void {
			trace("netStatusHandler 2 : " + event.info.code);
        }
		private function errorHandler2(e:*=null):void {
			trace("errorHandler 2");
        	closeStream2();
        }
		private function closeStream2():void{
			trace("closeStream 2");
			/*if(ns2!=null){
				trace("  ns.close()");
        		ns2.close();
        		ns2 = null;
			}*/
		}
		// Now in string
		private function now():String{
			var d:Date = new Date();
			var m:uint = d.month + 1; // because Date.month begins at 0
			return d.fullYear + (m<10?("0"+m):m) + (d.date<10?("0"+d.date):d.date) + (d.hours<10?("0"+d.hours):d.hours) + (d.minutes<10?("0"+d.minutes):d.minutes) + (d.seconds<10?("0"+d.seconds):d.seconds);
		}
		
	}
	
}
