IriSP.Widgets.MusitagAnnotations = function(player, config) {
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.MusitagAnnotations.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.MusitagAnnotations.prototype.defaults = {
    annotation_type: 'musitag',
    columns: 15,
    max_by_column: 10,
    emoticons: ['happy', 'unhappy', 'laughing', 'surprised'],
    colors: ['red', 'yellow', 'green', 'blue']
};

IriSP.Widgets.MusitagAnnotations.prototype.draw = function() {
    var _html = '',
        _annotations = this.getWidgetAnnotations(),
        _duration = this.source.getDuration().milliseconds,
        _sliceDuration = _duration/this.columns,
        _this = this;
    _annotations.forEach(function(_annotation) {
        var _tags = _annotation.getTagTexts();
        _annotation.color_tag = false;
        _annotation.emoticon_tag = false;
        _tags.forEach(function(_tag) {
            if (_this.emoticons.indexOf(_tag) != -1) {
                _annotation.emoticon_tag = _tag;
            }
            if (_this.colors.indexOf(_tag) != -1) {
                _annotation.color_tag = _tag;
            }
        });
    });
    for (var i = 0; i < this.columns; i++) {
        var _sliceStart = i * _sliceDuration,
            _sliceEnd = (i+1) * _sliceDuration,
            _column = _annotations.filter(function(_annotation) {
                return _annotation.begin >= _sliceStart
                    && _annotation.begin < _sliceEnd
                    && _annotation.emoticon_tag
                    && _annotation.color_tag
            }).sortBy(function(_annotation) {
                return _annotation.created;
            });
        if (_column.length > this.max_by_column) {
            _column = _column.slice(_column.length - this.max_by_column, _column.length);
        }
        _html += '<div class="Musitag-Annotations-column">';
        _html += _column.map(function(_annotation) {
            return '<div class="Musitag-Annotations-tag" begin-time="' + _annotation.begin + '">'
                + '<div class="Musitag-container-50">'
                + '<div class="Musitag-shadow"></div>'
                + '<div class="Musitag-color Musitag-' + _annotation.color_tag + '"></div>'
                + '<div class="Musitag-emoticon Musitag-' + _annotation.emoticon_tag + '"></div>'
                + '</div><div class="Musitag-Annotations-Balloon"></div></div>';
        }).join('');
        _html += '</div>';
    }
    this.$.html(_html);
    this.$.find('.Musitag-Annotations-tag .Musitag-container-50').click(function() {
        var _el = IriSP.jQuery(this).parent();
        _this.player.popcorn.currentTime(_el.attr("begin-time") / 1000);
    });
    this.$.find('.Musitag-Annotations-tag').mouseover(function() {
        var _el = IriSP.jQuery(this);
        _this.$.find('.Musitag-Annotations-Balloon').hide();
        _el.find('.Musitag-Annotations-Balloon').show();
    });
}