IriSP.Widgets.MusitagAnnotator = function(player, config) {
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.MusitagAnnotator.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.MusitagAnnotator.prototype.defaults = {
    min_left: -90,
    max_right: 900,
    width: 870
};

IriSP.Widgets.MusitagAnnotator.prototype.template =
    '<div class="Musitag-Annotator-PositionBar"></div><div class="Musitag-Annotator-Main">'
    + '<div class="Musitag-Annotator-section"><h2>1</h2>'
    + '    <h3>Choisis<br />une couleur</h3>'
    + '    <div class="Musitag-Annotator-selector">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-red"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-yellow"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-green"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-blue"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>2</h2>'
    + '    <h3>Choisis<br />une émotion</h3>'
    + '    <div class="Musitag-Annotator-selector">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-happy"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-unhappy"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-laughing"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-surprised"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>3</h2>'
    + '    <h3>Enregistre<br />ta voix</h3>'
    + '    <div class="Musitag-Annotator-record"></div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>4</h2>'
    + '    <h3>Envoie<br />ton Musitag</h3>'
    + '    <div class="Musitag-Annotator-Note">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSend">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon hidden"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-close"></div>'
    + '</div></div>';

IriSP.Widgets.MusitagAnnotator.prototype.draw = function() {
    this.renderTemplate();
    this.position_bar = this.$.find(".Musitag-Annotator-PositionBar");
    this.position_bar.hide();
    this.position_width = this.position_bar.outerWidth();
    this.main_div = this.$.find(".Musitag-Annotator-Main");
    this.$.hide();
    this.main_width = this.main_div.outerWidth();
    this.bindPopcorn("timeupdate","onTimeupdate");
    this.bindPopcorn("IriSP.MusitagAnnotator.hide","hide");
    this.bindPopcorn("IriSP.MusitagAnnotator.show","show");
    this.$.find('.Musitag-Annotator-tagInSelector').click(function() {
        var _class = IriSP.jQuery(this).children(':last-child').attr('class'),
            _classes = _class.split(' ');
        IriSP.jQuery('.Musitag-Annotator-tagInSend .' + _classes[0]).attr('class',_class);
        IriSP.jQuery(this).siblings().removeClass('down')
            .children(':last-child').css('opacity',.35);
        IriSP.jQuery(this).addClass('down')
            .children(':last-child').css('opacity',1);
    });
    var _this = this;
    this.$.find('.Musitag-Annotator-close').click(function() {
        _this.hide();
        _this.player.popcorn.trigger("IriSP.MusitagAndYou.show");
    })
}

IriSP.Widgets.MusitagAnnotator.prototype.onTimeupdate = function() {
    var _x = Math.floor(this.width * this.player.popcorn.currentTime() / this.source.getDuration().getSeconds());
    this.position_bar.css("margin-left", (_x - this.position_width / 2)+"px");
    this.main_div.css("margin-left",Math.max(this.min_left, Math.min(this.max_right - this.main_width, _x - this.main_width / 2))+"px");
}

IriSP.Widgets.MusitagAnnotator.prototype.show = function() {
    this.$.show();
    this.position_bar.slideDown(200);
}

IriSP.Widgets.MusitagAnnotator.prototype.hide = function() {
    var _this = this;
    this.position_bar.slideUp(200, function() {
        _this.$.hide();
    });
}
