# Django settings for tralalere project.
import tralalere

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.', # Add 'postgresql_psycopg2', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': '',                      # Or path to database file if using sqlite3.
        'USER': '',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': '',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'UTC'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-FR'

ugettext = lambda s:s

LANGUAGES = (
  ('fr', ugettext('French')),
)


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = False

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = ''

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = ''

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
#    'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = ''

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

from django.conf.global_settings import TEMPLATE_CONTEXT_PROCESSORS
TEMPLATE_CONTEXT_PROCESSORS += (
    "django.core.context_processors.request",
    'django.core.context_processors.i18n',
    "ldt.utils.context_processors.ldt_context",
)

MIDDLEWARE_CLASSES = (
    'tralalere.utils.ForceDefaultLanguageMiddleware',
#    'django.middleware.cache.UpdateCacheMiddleware',
    'django.middleware.common.CommonMiddleware',
#    'django.middleware.cache.FetchFromCacheMiddleware',
    'ldt.ldt_utils.middleware.swfupload.SWFUploadMiddleware',        
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    # Uncomment the next line for simple clickjacking protection:
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django_openid_consumer.middleware.OpenIDMiddleware',
    'ldt.ldt_utils.middleware.userprofile.LanguageMiddleware',
    'ldt.security.middleware.SecurityMiddleware',    
    'ldt.api.middleware.pistonput.PistonPutMiddleware',
    #'debug_toolbar.middleware.DebugToolbarMiddleware'
)

ROOT_URLCONF = 'tralalere.urls'

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = 'tralalere.wsgi.application'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

INSTALLED_APPS = (
    'django_extensions',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    # Uncomment the next line to enable the admin:
    'django.contrib.admin',
    'tralalere',
    'registration',
    'tagging',
    'ldt',
    'ldt.core',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.user',
    'ldt.management',
    'oauth_provider',
    'django_openid_consumer',
    'piston',
    'social_auth',
    'south',
    'guardian',
    'sorl.thumbnail',
    #'debug_toolbar',
    # Uncomment the next line to enable admin documentation:
    # 'django.contrib.admindocs',
)

# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error when DEBUG=False.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        }
    },
    'loggers': {
        'django.request': {
            'handlers': ['mail_admins'],
            'level': 'ERROR',
            'propagate': True,
        },
    }
}

AUTH_PROFILE_MODULE = 'user.UserProfile'

DECOUPAGE_BLACKLIST = (
     "de_PPP",
)
 
ZIP_BLACKLIST = (
     "__MACOSX",
)

AUTHENTICATION_BACKENDS = (
    'social_auth.backends.twitter.TwitterBackend',
    'social_auth.backends.facebook.FacebookBackend',
#    'social_auth.backends.google.GoogleOAuthBackend',
#    'social_auth.backends.google.GoogleOAuth2Backend',
    'social_auth.backends.google.GoogleBackend',
    'social_auth.backends.yahoo.YahooBackend',
#    'social_auth.backends.contrib.linkedin.LinkedinBackend',
#    'social_auth.backends.contrib.LiveJournalBackend',
#    'social_auth.backends.contrib.orkut.OrkutBackend',
    'social_auth.backends.OpenIDBackend',
    'django.contrib.auth.backends.ModelBackend',
    'guardian.backends.ObjectPermissionBackend',
)
SOCIAL_AUTH_IMPORT_BACKENDS = (
    'myproy.social_auth_extra_services',
)

ACCOUNT_ACTIVATION_DAYS = 7 

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 0
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 10

LDT_MAX_CONTENTS_PER_PAGE = 10
LDT_MAX_PROJECTS_PER_PAGE = 10


OAUTH_PROVIDER_KEY_SIZE = 32
OAUTH_PROVIDER_SECRET_SIZE = 32
OAUTH_PROVIDER_VERIFIER_SIZE = 10
OAUTH_PROVIDER_CONSUMER_KEY_SIZE = 256
OAUTH_AUTHORIZE_VIEW = 'oauth_provider.views.fake_authorize_view'
OAUTH_CALLBACK_VIEW = 'oauth_provider.views.fake_callback_view'
TEST_WEBSERVER_ADDRPORT = "127.0.0.1:8888"

TWITTER_CONSUMER_KEY     = 'UxAdbOLSo4Mx3CXIwDG9Eg'
TWITTER_CONSUMER_SECRET  = '2PcWgdjnJL6Vp8srB40jeAo0fjMEtDnUwmAia6EUww'
FACEBOOK_APP_ID = '163134140411313'
FACEBOOK_API_SECRET = 'f25e0754a44f0d90d3f4d9ea961ff012'

SOCIAL_AUTH_COMPLETE_URL_NAME  = 'complete'
SOCIAL_AUTH_ASSOCIATE_URL_NAME = 'associate_complete'


AUTO_INDEX_AFTER_SAVE = True

ANONYMOUS_USER_ID = -1

WEB_VERSION = tralalere.get_version()

DIVISIONS_FOR_STAT_ANNOTATION = 64

FRONT_TAG_LIST = []

DEFAULT_CONTENT_ICON = "thumbnails/contents/content_default_icon.png"
DEFAULT_PROJECT_ICON = "thumbnails/projects/project_default_icon.png"
DEFAULT_USER_ICON = "thumbnails/users/user_default_icon.png"
DEFAULT_GROUP_ICON = "thumbnails/groups/group_default_icon.png"
PROFILE_IMG_MAX_SIZE = 1000000

USE_GROUP_PERMISSIONS = ['Project', 'Content', 'Media']
FORBIDDEN_STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/mp4:video/forbidden_stream.mp4?old_path="
PUBLIC_GROUP_NAME = 'everyone'
MAX_USERS_SEARCH = 20

SYNTAX = {
          '++' : 'OK',
          '--' : 'KO',
          '==' : 'REF',
          '??' : 'Q'
          }

EXTERNAL_STREAM_SRC = ['youtube.com', 'dailymotion.com']


from tralalere.config import *

if not "LOGIN_URL" in locals():
    LOGIN_URL = BASE_URL + 'tralalere/accounts/login/'
if not "LOGOUT_URL" in locals():
    LOGOUT_URL = BASE_URL + 'tralalere/accounts/disconnect/'
if not "LOGIN_REDIRECT_URL" in locals():
    LOGIN_REDIRECT_URL = BASE_URL + 'tralalere/ldt/'
if not "LOGOUT_REDIRECT_URL" in locals():
    LOGOUT_REDIRECT_URL = BASE_URL + 'tralalere/accounts/login'
if not "PROFILE_REDIRECT_URL" in locals():
    PROFILE_REDIRECT_URL = BASE_URL + 'tralalere/auth_accounts/create/profile'

if not "LOGIN_ERROR_URL" in locals():
    LOGIN_ERROR_URL = BASE_URL + 'tralalere/accounts/login'

if not "GLOBAL_LOG_LEVEL" in locals():
    GLOBAL_LOG_LEVEL = LOG_LEVEL
if not "GLOBAL_LOG_HANDLERS" in locals():
    GLOBAL_LOG_HANDLERS = [{'handler':logging.StreamHandler, 'format':"%(asctime)s - %(levelname)s : %(message)s"}]

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
if not "ADMIN_MEDIA_PREFIX" in locals():
    ADMIN_MEDIA_PREFIX = STATIC_URL + 'admin/'
# Used in a lot of templates
if not "LDT_MEDIA_PREFIX" in locals():
    LDT_MEDIA_PREFIX = STATIC_URL + 'ldt/'
# URL that handles the media served from MEDIA_ROOT.
if not "MEDIA_URL" in locals():
    MEDIA_URL = BASE_URL + 'static/media/'
    
#INTERNAL_IPS = ('127.0.0.1',)
  

