import platform

from lib_create_env import lib_generate_install_methods, install_pylucene, install_psycopg2

system_str = platform.system()

if system_str == 'Windows':
    INSTALLS = [
    ('JCC','easy_install',None,None),
    ('PSYCOPG2',install_psycopg2,None,None),
    ('PYLUCENE','easy_install',None,None),
    ]
else:
    INSTALLS = [
    ('PYLUCENE',install_pylucene,None,None),
    ('PSYCOPG2', 'pip', None, None),
    ]

if system_str == 'Linux':
    INSTALLS.extend([
    ('DISTRIBUTE', 'pip', None, None),
    ])

INSTALLS.extend([ #(key,method, option_str, dict_extra_env)
    ('SOUTH', 'pip', None, None),
    ('PIL', 'easy_install', None, None), 
    ('DJANGO','pip', None, None),
    ('DJANGO-EXTENSIONS', 'pip', None, None),
    ('DJANGO-REGISTRATION', 'easy_install', '-Z', None),
    ('DJANGO-TAGGING', 'pip', None, None),
    ('DJANGO-PISTON', 'easy_install', None, None),
    ('HTTPLIB2', 'pip', None, None),
    ('OAUTH2', 'easy_install', None, None),
    ('DJANGO-OAUTH-PLUS', 'pip', None, None),
    ('OPENID', 'pip', None, None),
    ('DJANGO_OPENID_CONSUMER', 'pip', None, None),
    ('SOCIAL_AUTH', 'easy_install', None, None),
    ('DJANGO_GUARDIAN', 'pip', None, None),
    ('SORL_THUMBNAIL', 'pip', None, None),
    ('LDT', 'pip', None, None),
])

if system_str == "Darwin":
    INSTALLS.extend([
    ('LXML', 'easy_install', None, {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.7.8', 'LIBXSLT_VERSION': '1.1.26', 'LIBICONV_VERSION': '1.13.1'}),
    ])
else:
    INSTALLS.extend([
    ('LXML', 'easy_install', None, None),
    ])


def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS)
