﻿package  {
	
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.AsyncErrorEvent;
	import flash.events.ErrorEvent;
	import flash.events.ActivityEvent;
	import flash.events.Event;
	
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	
	import flash.text.TextField;
	
	import flash.system.Security;
	
	import flash.media.Microphone;
	
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import flash.utils.getTimer;
	
	import fl.controls.ProgressBar;
	import fl.controls.ProgressBarDirection;
	import fl.controls.ProgressBarMode;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import fl.controls.Slider;
	import fl.events.SliderEvent;
	
	public class record_mic extends MovieClip {
		
		private var t:TextField;
		private var r:SimpleButton;
		private var s:Sprite;
		private var p:Sprite;
		
		private var urlServer:String = "rtmp://media.iri.centrepompidou.fr/ddc_micro_record";
		private var nc:NetConnection;
		private var ns:NetStream;
		private var ns2:NetStream;
		private var mic:Microphone;
		private var filename:String;
		private var recordStopped:Boolean = false;
		
		// Draw mic feedback
		private var pb:ProgressBar;
		private var activityCurve:Sprite;
		private var micGain:Slider;
		// Variables for the activity curve
		private var xInc:int = 0;
		private var xSpeed:int = 2;
		private var activityWidth:Number;
		// Intervals used to draw the curve et keep track of the duration of the recording
		private var drawCurve:Number;
		private var timecodeInterval:Number;
		private var timecode:Number = 0;
		
		
		public function record_mic() {
			// constructor code
			Security.allowDomain("*");
			Security.allowInsecureDomain("*");
			
			//t = _t;
			r = _recordBtn;
			s = _stopBtn;
			p = _playBtn;
			pb = _pb;
			activityWidth = _act.width;
			activityCurve = _act._activityCurve;
			micGain = _micGain;
			trace("t = " + t + ", r = " + r + ", s = " + s + ", p = " + p + ", pb = " + pb);
			
			//r.buttonMode = r.useHandCursor = 
			s.buttonMode = s.useHandCursor = p.buttonMode = p.useHandCursor = true;
			pb.mode = ProgressBarMode.MANUAL;
			r.addEventListener(MouseEvent.CLICK, startRecord);
			s.addEventListener(MouseEvent.CLICK, stopRecord);
			p.addEventListener(MouseEvent.CLICK, playRecord);
		}
		private function startRecord(e:MouseEvent=null):void{
			trace("startRecord nc = " + nc);
			if (nc==null){
				trace("  startRecord 2");
				nc = new NetConnection();
				nc.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler, false, 0, true);
				nc.addEventListener(IOErrorEvent.IO_ERROR, errorHandler, false, 0, true);
				nc.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorHandler, false, 0, true);
				nc.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler, false, 0, true);    	
				nc.connect(urlServer);
			}
			else{
				publish();
			}
		}
		private function errorHandler(e:*=null):void {
			trace("errorHandler");
        	closeStream();
        }
		private function closeStream():void{
			trace("closeStream");
			if(ns!=null){
				trace("  ns.close()");
        		ns.close();
        		ns = null;
			}
		}
		private function netStatusHandler(event:NetStatusEvent):void {
			trace("netStatusHandler : " + event.info.code);
        	switch (event.info.code) {
	        	case 'NetConnection.Connect.Success':
					publish();
	        		break;
	        	case 'NetConnection.Connect.Failed':
	        	case 'NetConnection.Connect.Reject':
	        	case 'NetConnection.Connect.Closed':
	        		//closeStream();
	        		break;
        	}
        }
		// send data over rtmp
		private function publish():void {
			trace("publish (ns==null && nc!=null && nc.connected) = " + (ns==null && nc!=null && nc.connected));
			if(nc!=null && nc.connected) {
				trace("  publish 2");
				ns = new NetStream(nc);
				ns.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler, false, 0, true);
				ns.addEventListener(IOErrorEvent.IO_ERROR, errorHandler, false, 0, true);
				ns.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler, false, 0, true);
				// informs the server to record what it receives
				// in fact file name is passed as the user name (the server is meant to record everything it has to in a file named from the user name)	
				filename = "r_" + now();
				trace("filename = " + filename);
				ns.publish(filename, 'record');
				mic = Microphone.getMicrophone(-1);
				mic.rate = 22;
				micGain.minimum = 0;
				micGain.maximum = 100;
				micGain.value = mic.gain = 50;
				micGain.addEventListener(SliderEvent.CHANGE, onSliderChange);
				//			mic.addEventListener(ActivityEvent.ACTIVITY, activity);
				mic.addEventListener(ActivityEvent.ACTIVITY, runMicActivity);
				mic.setUseEchoSuppression(true);
				ns.attachAudio(mic);
			}
		}
		// stop the recording of audio to the stream
		private function stopRecord(e:*=null):void{
			trace("stopRecord (ns!=null) = " + (ns!=null));
			if(ns!=null){
				trace("  stopRecord 2");
				recordStopped = true;
				ns.play(false); // flushes the recording buffer
    			ns.close();
			}
		}
		// plays back the audio that was recorded
		private function playRecord(e:*=null):void{
			trace("playRecord (ns!=null && recordStopped) = " + (ns!=null && recordStopped));
			if(recordStopped){
				trace("  playRecord 2");
				ns2 = new NetStream(nc);
				ns2.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler2, false, 0, true);
				ns2.addEventListener(IOErrorEvent.IO_ERROR, errorHandler2, false, 0, true);
				ns2.addEventListener(AsyncErrorEvent.ASYNC_ERROR, errorHandler2, false, 0, true);
				ns2.play(filename);
			}
		}
		private function netStatusHandler2(event:NetStatusEvent):void {
			trace("netStatusHandler 2 : " + event.info.code);
        }
		private function errorHandler2(e:*=null):void {
			trace("errorHandler 2");
        	closeStream2();
        }
		private function closeStream2():void{
			trace("closeStream 2");
			/*if(ns2!=null){
				trace("  ns.close()");
        		ns2.close();
        		ns2 = null;
			}*/
		}
		// Now in string
		private function now():String{
			var d:Date = new Date();
			var m:uint = d.month + 1; // because Date.month begins at 0
			return d.fullYear + (m<10?("0"+m):m) + (d.date<10?("0"+d.date):d.date) + (d.hours<10?("0"+d.hours):d.hours) + (d.minutes<10?("0"+d.minutes):d.minutes) + (d.seconds<10?("0"+d.seconds):d.seconds);
		}
		
		// sets the module ready to record mic activity changes
		private function runMicActivity(event:ActivityEvent):void {
			trace("runMicActivity");
			addEventListener(Event.ENTER_FRAME, showMicActivity);
			// Start activity curve feedback, every second
			activityCurve.graphics.clear();
			activityCurve.graphics.lineStyle(1, 0xc4c4c4, 1);
			activityCurve.graphics.moveTo(0, 20);
			activityCurve.graphics.beginFill(0xc4c4c4, 100);
			xInc = 0;
			activityCurve.x = 1;
			var tmr:Timer = new Timer(1000, 1000);
			tmr.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
			tmr.addEventListener(TimerEvent.TIMER, drawSoundCurve);
			tmr.start();
		}
		// updates the progress bar relating to mic activity
		private function showMicActivity(e:Event):void {
			//trace("showMicActivity res = " + (mic.activityLevel*mic.gain/100));
			//pb.setProgress(mic.activityLevel*mic.gain/100 ,100);
			pb.setProgress(mic.activityLevel,100);
		}
		// updates the actiity curve relating to mic activity
		private function drawSoundCurve(e:TimerEvent):void {
			trace("drawSoundCurve mic.activityLevel =  " + mic.activityLevel + ", mic.gain = " + mic.gain + ", h = " + (19*mic.activityLevel/100));
			activityCurve.graphics.lineTo(xInc, 19 - (19*mic.activityLevel/100));	
			activityCurve.graphics.lineTo(xInc, 19);
			if(xInc>activityWidth){
				activityCurve.x -= xSpeed;
			}
			xInc += xSpeed;
		}
		private function onTimerComplete(e:TimerEvent):void {
			trace("onTimerEnd");
		}
		// Updates mic gain
		private function onSliderChange(e:SliderEvent):void {
			trace("onSliderChange");
			mic.gain = micGain.value;
		}
		
	}
	
}
