IriSP.Widgets.MusitagAnnotator = function(player, config) {
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.MusitagAnnotator.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.MusitagAnnotator.prototype.defaults = {
    min_left: -90,
    max_right: 900,
    width: 870
};

IriSP.Widgets.MusitagAnnotator.prototype.template =
    '<div class="Musitag-Annotator-PositionBar"></div><div class="Musitag-Annotator-Main">'
    + '<div class="Musitag-Annotator-section"><h2>1</h2>'
    + '    <h3>Choisis<br />une couleur</h3>'
    + '    <div class="Musitag-Annotator-selector">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-red"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-yellow"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-green"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-color Musitag-blue"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>2</h2>'
    + '    <h3>Choisis<br />une émotion</h3>'
    + '    <div class="Musitag-Annotator-selector">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-happy"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-unhappy"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-laughing"></div>'
    + '        </div>'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSelector">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon Musitag-surprised"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>3</h2>'
    + '    <h3>Enregistre<br />ta voix</h3>'
    + '    <div class="Musitag-Annotator-record">'
    
    + '    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="220" height="140" id="record_mic" align="middle">'
    + '        <param name="movie" value="../../script/record_mic/record_mic.swf" />'
    + '        <param name="quality" value="high" />'
    + '        <param name="bgcolor" value="#ffffff" />'
    + '        <param name="play" value="true" />'
    + '        <param name="loop" value="true" />'
    + '        <param name="wmode" value="transparent" />'
    + '        <param name="scale" value="showall" />'
    + '        <param name="menu" value="true" />'
    + '        <param name="devicefont" value="false" />'
    + '        <param name="salign" value="" />'
    + '        <param name="allowScriptAccess" value="always" />'
    + '        <param name="allowFullScreen" value="true" />'
    + '        <param name="flashvars" value="playVisible=true">'
    + '        <embed src="../../script/record_mic/record_mic.swf" quality="high" bgcolor="#ffffff"'
    + '             width="220" height="140" name="ExternalInterfaceExample" align="middle"'
    + '             play="true" loop="false" quality="high" allowScriptAccess="always" '
    + '             type="application/x-shockwave-flash" allowFullScreen="true" wmode="transparent" '
    + '             flashvars="playVisible=true"'
    + '             pluginspage="http://www.macromedia.com/go/getflashplayer">'
    + '        </embed>'
    + '    </object>'
    
    
    +'</div>'
    + '</div>'
    + '<div class="Musitag-Annotator-separator"></div>'
    + '<div class="Musitag-Annotator-section">'
    + '    <h2>4</h2>'
    + '    <h3>Envoie<br />ton Musitag</h3>'
    + '    <div class="Musitag-Annotator-Note">'
    + '        <div class="Musitag-container-80 Musitag-Annotator-tagInSend">'
    + '            <div class="Musitag-shadow"></div>'
    + '            <div class="Musitag-color"></div>'
    + '            <div class="Musitag-emoticon"></div>'
    + '        </div>'
    + '    </div>'
    + '</div>'
    + '<div class="Musitag-Annotator-close"></div>'
    + '</div></div>';

IriSP.Widgets.MusitagAnnotator.prototype.draw = function() {
    this.renderTemplate();
    this.position_bar = this.$.find(".Musitag-Annotator-PositionBar");
    this.position_bar.hide();
    this.position_width = this.position_bar.outerWidth();
    this.main_div = this.$.find(".Musitag-Annotator-Main");
    this.$.hide();
    this.main_width = this.main_div.outerWidth();
    this.bindPopcorn("timeupdate","onTimeupdate");
    this.bindPopcorn("IriSP.MusitagAnnotator.hide","hide");
    this.bindPopcorn("IriSP.MusitagAnnotator.show","show");
    this.recorder = this.$.find("embed")[0];
    
    var _this = this;
    
    this.$.find('.Musitag-Annotator-tagInSelector').click(function() {
        var _class = IriSP.jQuery(this).children(':last-child').attr('class'),
            _classes = _class.split(' '),
            _type = _classes[0].replace(/^\w+-/,""),
            _value = _classes[1].replace(/^\w+-/,"");
        _this.annotation[_type] = _value;
        _this.checkAnnotation();
        IriSP.jQuery('.Musitag-Annotator-tagInSend .' + _classes[0]).attr('class',_class);
        IriSP.jQuery(this).siblings().removeClass('down')
            .children(':last-child').css('opacity',.35);
        IriSP.jQuery(this).addClass('down')
            .children(':last-child').css('opacity',1);
    });
    
    this.$.find('.Musitag-Annotator-close').click(function() {
        _this.recorder.stopRecord();
        _this.hide();
        _this.player.popcorn.trigger("IriSP.MusitagAndYou.show");
    });
    
    this.$.find('.Musitag-Annotator-Note').click(function() {
       _this.recorder.stopRecord();
    });
    
    window.setAudioUrl = function(_url) {
        _this.annotation.audio_url = _url;
        console.log(_url);
    }
}

IriSP.Widgets.MusitagAnnotator.prototype.onTimeupdate = function() {
    var _x = Math.floor(this.width * this.player.popcorn.currentTime() / this.source.getDuration().getSeconds());
    this.position_bar.css("margin-left", (_x - this.position_width / 2)+"px");
    this.main_div.css("margin-left",Math.max(this.min_left, Math.min(this.max_right - this.main_width, _x - this.main_width / 2))+"px");
}

IriSP.Widgets.MusitagAnnotator.prototype.checkAnnotation = function() {
    var _res = this.annotation.emoticon && this.annotation.color;
    this.$.find('.Musitag-Annotator-Note').css("opacity", _res ? 1 : .5);
    return _res;
}

IriSP.Widgets.MusitagAnnotator.prototype.show = function() {
    this.$.show();
    this.$.find('.Musitag-Annotator-tagInSelector').removeClass("down");
    this.$.find(".Musitag-Annotator-tagInSend .Musitag-color").attr("class","Musitag-color");
    this.$.find(".Musitag-Annotator-tagInSend .Musitag-emoticon").attr("class","Musitag-emoticon hidden");
    this.annotation = {
        audio_url: false,
        emoticon: false,
        color: false
    };
    this.checkAnnotation();
    this.position_bar.slideDown(200);
}

IriSP.Widgets.MusitagAnnotator.prototype.hide = function() {
    var _this = this;
    this.position_bar.slideUp(200, function() {
        _this.$.hide();
    });
}
