IriSP.Widgets.MusitagAndYou = function(player, config) {
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.MusitagAndYou.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.MusitagAndYou.prototype.defaults = {
    min_left: -90,
    max_right: 900,
    width: 870
};

IriSP.Widgets.MusitagAndYou.prototype.template =
    '<div class="Musitag-AndYou-PositionBar"></div><div class="Musitag-AndYou-Main">'
    + '<div class="Musitag-AndYou-Tag Musitag-container-50">'
    + '<div class="Musitag-shadow"></div>'
    + '<div class="Musitag-color Musitag-green Musitag-AndYou-crossfade Musitag-AndYou-anim-6s Musitag-AndYou-cf-3"></div>'
    + '<div class="Musitag-color Musitag-yellow Musitag-AndYou-crossfade Musitag-AndYou-anim-6s Musitag-AndYou-cf-2"></div>'
    + '<div class="Musitag-color Musitag-red Musitag-AndYou-crossfade Musitag-AndYou-anim-6s Musitag-AndYou-cf-1"></div>'
    + '<div class="Musitag-color Musitag-blue Musitag-AndYou-crossfade Musitag-AndYou-anim-6s"></div>'
    + '<div class="Musitag-emoticon Musitag-laughing Musitag-AndYou-crossfade Musitag-AndYou-anim-8s"></div>'
    + '<div class="Musitag-emoticon Musitag-happy Musitag-AndYou-crossfade Musitag-AndYou-anim-8s Musitag-AndYou-cf-1"></div>'
    + '<div class="Musitag-emoticon Musitag-unhappy Musitag-AndYou-crossfade Musitag-AndYou-anim-8s Musitag-AndYou-cf-2"></div>'
    + '<div class="Musitag-emoticon Musitag-surprised Musitag-AndYou-crossfade Musitag-AndYou-anim-8s Musitag-AndYou-cf-3"></div></div></div>';

IriSP.Widgets.MusitagAndYou.prototype.draw = function() {
    this.renderTemplate();
    this.position_bar = this.$.find(".Musitag-AndYou-PositionBar");
    this.position_bar.hide();
    this.position_width = this.position_bar.outerWidth();
    this.main_div = this.$.find(".Musitag-AndYou-Main");
    this.main_width = this.main_div.outerWidth();
    this.bindPopcorn("timeupdate","onTimeupdate");
    this.bindPopcorn("IriSP.MusitagAndYou.hide","hide");
    this.bindPopcorn("IriSP.MusitagAndYou.show","show");
    this.show();
    var _this = this;
    this.main_div.click(function() {
        _this.hide();
        _this.player.popcorn.trigger("IriSP.MusitagAnnotator.show");
    })
}

IriSP.Widgets.MusitagAndYou.prototype.onTimeupdate = function() {
    var _x = Math.floor(this.width * this.player.popcorn.currentTime() / this.source.getDuration().getSeconds());
    this.position_bar.css("margin-left", (_x - this.position_width / 2)+"px");
    this.main_div.css("margin-left",Math.max(this.min_left, Math.min(this.max_right - this.main_width, _x - this.main_width / 2))+"px");
}

IriSP.Widgets.MusitagAndYou.prototype.show = function() {
    this.$.show();
    this.position_bar.slideDown(500);
}

IriSP.Widgets.MusitagAndYou.prototype.hide = function() {
    var _this = this;
    this.position_bar.slideUp(500, function() {
        _this.$.hide();
    });
}
