IriSP.Widgets.MusitagAnnotations = function(player, config) {
    IriSP.Widgets.Widget.call(this, player, config);
};

IriSP.Widgets.MusitagAnnotations.prototype = new IriSP.Widgets.Widget();

IriSP.Widgets.MusitagAnnotations.prototype.template =
    '<div class="Musitag-Annotations-Main"></div><div id="Musitag-Annotations-Audioplayer"></div>';
    
IriSP.Widgets.MusitagAnnotations.prototype.annotation_template =
    '<div class="Musitag-Annotations-tag" begin-time="{{annotation.begin.milliseconds}}" title="{{annotation.color.name}}, {{annotation.emoticon.name}} {{l10n.at_timecode}} {{annotation.begin}}">'
    + '<div class="Musitag-container-50">'
    + '<div class="Musitag-shadow"></div>'
    + '<div class="Musitag-color Musitag-{{annotation.color.tag}}"></div>'
    + '<div class="Musitag-emoticon Musitag-{{annotation.emoticon.tag}}"></div>'
    + '</div>{{#annotation.audio}}<div class="Musitag-Annotations-Balloon" audio-url="{{annotation.audio.href}}" title="{{l10n.play_voice}}"></div>{{/annotation.audio}}'
    + '</div>';

IriSP.Widgets.MusitagAnnotations.prototype.messages = {
    fr: {
        at_timecode: "à",
        play_voice: "Lire l'annotation vocale"
    },
    en: {
        at_timecode: "at",
        play_voice: "Play voice annotation"
    }
}

IriSP.Widgets.MusitagAnnotations.prototype.defaults = {
    annotation_type: false,
    columns: 15,
    max_by_column: 10,
    emoticons: [
        { tag: "happy", name: "content"},
        { tag: "unhappy", name: "mécontent"},
        { tag: "laughing", name: "rieur"},
        { tag: "surprised", name: "étonné"}
    ],
    colors: [
        { tag: "red", name: "rouge"},
        { tag: "yellow", name: "jaune"},
        { tag: "green", name: "vert"},
        { tag: "blue", name: "bleu"}
    ],
    rtmp_streamer: "rtmp://media.iri.centrepompidou.fr/ddc_micro_record/"
};

IriSP.Widgets.MusitagAnnotations.prototype.draw = function() {
    this.renderTemplate();
    this.bindPopcorn("IriSP.MusitagAnnotations.redraw","redraw");
    this.$main = this.$.find(".Musitag-Annotations-Main");
    var _this = this;
    this.jwplayer = jwplayer("Musitag-Annotations-Audioplayer");
    this.jwplayer.setup({
        flashplayer: IriSP.getLib("jwPlayerSWF"),
        width: 1,
        height: 1,
        provider: "rtmp",
        events: {
            onPause: function() {
                _this.setPlayState(false);
            },
            onIdle: function() {
                _this.setPlayState(false);
            }
        }
    });
    this.current_audio = false;
    this.annotation_playing = false;
    this.media_playing = !this.player.popcorn.media.paused;
    this.redraw();
}

IriSP.Widgets.MusitagAnnotations.prototype.setPlayState = function(_playState) {
    this.annotation_playing = _playState;
    if (_playState) {
        this.$main.find(".Musitag-Annotations-Balloon").addClass("pause");
    } else {
        this.$main.find(".Musitag-Annotations-Balloon").removeClass("pause");
        if (this.media_playing) {
            this.player.popcorn.play();
        }
    }
}

IriSP.Widgets.MusitagAnnotations.prototype.redraw = function() {
    
    var _html = '',
        _annotations = this.getWidgetAnnotations(),
        _duration = this.source.getDuration().milliseconds,
        _sliceDuration = _duration/this.columns,
        _this = this;
    _annotations.forEach(function(_annotation) {
        var _tags = _annotation.getTagTexts();
        _annotation.emoticon = IriSP._(_this.emoticons).find(function(_emoticon) {
            return IriSP._(_tags).find(function(_tag) {
                return _tag == _emoticon.tag;
            });
        });
        _annotation.color = IriSP._(_this.colors).find(function(_color) {
            return IriSP._(_tags).find(function(_tag) {
                return _tag == _color.tag;
            });
        });
    });
    for (var i = 0; i < this.columns; i++) {
        var _sliceStart = i * _sliceDuration,
            _sliceEnd = (i+1) * _sliceDuration,
            _column = _annotations.filter(function(_annotation) {
                return _annotation.begin >= _sliceStart
                    && _annotation.begin < _sliceEnd
                    && _annotation.emoticon
                    && _annotation.color
            }).sortBy(function(_annotation) {
                return _annotation.created;
            });
        if (_column.length > this.max_by_column) {
            _column = _column.slice(_column.length - this.max_by_column, _column.length);
        }
        _html += '<div class="Musitag-Annotations-column">';
        _html += _column.map(function(_annotation) {
            return Mustache.to_html(_this.annotation_template, { annotation: _annotation, l10n: _this.l10n });
        }).join('');
        _html += '</div>';
    }
    this.$main.html(_html);
    this.$main.find('.Musitag-Annotations-tag .Musitag-container-50').click(function() {
        var _el = IriSP.jQuery(this).parent();
        _this.player.popcorn.currentTime(_el.attr("begin-time") / 1000);
    });
    this.$main.find('.Musitag-Annotations-tag').mouseover(function() {
        var _el = IriSP.jQuery(this);
        _this.$.find('.Musitag-Annotations-Balloon').hide();
        _el.find('.Musitag-Annotations-Balloon').show();
    });
    this.$main.find('.Musitag-Annotations-Balloon').click(function() {
        var _el = IriSP.jQuery(this),
            _audiofile = _el.attr("audio-url").replace(_this.rtmp_streamer,"");
        if (_this.annotation_playing) {
            _this.jwplayer.pause();
            _this.loadAudio(_audiofile);
        } else {
            _this.loadAudio(_audiofile);
            _this.jwplayer.play();
            _this.setPlayState(true);
            _this.media_playing = !_this.player.popcorn.media.paused;
            if (_this.media_playing) {
                _this.player.popcorn.pause();
            }
        }
    });
}

IriSP.Widgets.MusitagAnnotations.prototype.loadAudio = function(_audiofile) {
    if (this.current_audio !== _audiofile) {
        this.jwplayer.load({
            file: _audiofile,
            streamer: this.rtmp_streamer
        });
        this.current_audio = _audiofile;
    }
}
