from django.conf.urls import patterns, include, url
from django.contrib import admin
from django.views.generic import TemplateView
from ldt.auth.views import login as pf_login


# Uncomment the next two lines to enable the admin:

admin.autodiscover()

js_info_dict = {  
    'packages': ('django.contrib.admin',), 
}


urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'tralalere.views.home', name='home'),
    # url(r'^tralalere/', include('tralalere.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    url(r'^admin/', include(admin.site.urls)),
    
    (r'^i18n/', include('django.conf.urls.i18n')),

    (r'^ldt/', include('ldt.ldt_utils.urls')),
    (r'^user/', include('ldt.user.urls')),
    (r'^api/', include('ldt.api.urls')),

    (r'^auth_accounts/', include('registration.backends.simple.urls')),

    (r'^accounts/', include('social_auth.urls')),
    url(r'^accounts/login/$',pf_login,{'template_name': 'registration/login.html'},name='auth_login'),
    (r'^oauth/', include('oauth_provider.urls')),
    url(r'^home$', 'tralalere.views.home', name='home'),
    url(r'^player/(?P<contentid>[\w\d-]+)$', 'tralalere.views.player', name='player'),       
    (r'^/?$', 'django.views.generic.simple.redirect_to', {'url': 'home'}),
    #(r'^static/(?P<path>.*)$', 'django.views.static.serve', {'document_root': settings.STATIC_ROOT}),
    
    (r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
)
