# -*- coding: utf-8 -*-
import os, logging
import tralalere

from environs import Env 

env = Env()
# Read .env into os.environ
env.read_env()

SITE_ID = 1

#BASE_DIR = os.path.dirname(os.path.abspath(__file__)).rstrip("/")+"/"
BASE_DIR = '/code/tralalere/'
BASE_URL = '/'
WEB_URL = 'http://tralalere.iri-research.org'


STREAM_SRC_PREFIX = ""

BASE_STATIC_URL = BASE_URL + 'static/' 
BASE_STATIC_ROOT = "/static/"

#STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/"
STREAM_URL = 'https://media.iri.centrepompidou.fr/'


# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = BASE_STATIC_ROOT + "media/"


STATIC_URL = BASE_STATIC_URL + 'site/'
# Absolute path to the directory that static files (js, css, swf...)
# DO NOT forget to do command line ./manage.py collectstatic to gather static media into the web/static folder
STATIC_ROOT = BASE_STATIC_ROOT + "site/"

# PATH to the ffmpeg executable, used to know automatically the media file duration 
FFMPEG_PATH = ""

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = BASE_STATIC_URL + "media/"

CONTENT_ROOT = MEDIA_ROOT + "/content/"

STREAM_PATH = CONTENT_ROOT

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = STATIC_URL + 'admin/'
LDT_MEDIA_PREFIX = STATIC_URL + 'ldt/'

#DATABASES = {
#    'default': {
#        'ENGINE': 'django.db.backends.postgresql_psycopg2', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
#        'NAME': 'tralalere',                      # Or path to database file if using sqlite3.
#        'USER': 'iri',                      # Not used with sqlite3.
#        'PASSWORD': 'iri',                  # Not used with sqlite3.
#        'HOST': 'localhost',                      # Set to empty string for localhost. Not used with sqlite3.
#        'PORT': '5432',                      # Set to empty string for default. Not used with sqlite3.
#    }
#}

DATABASES = {
    'default': env.dj_db_url("DATABASE_URL"),
}


DEBUG = True
TEMPLATE_DEBUG = DEBUG
LOG_LEVEL = logging.DEBUG

#INDEX_PATH = os.path.abspath(BASE_DIR + "../index/")
INDEX_PATH = '/index/'

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

GOOGLE_ANALYTICS_CODE = ''

#EMAIL_USE_TLS = True
#EMAIL_HOST = 'smtp.gmail.com'
#EMAIL_HOST_USER = 'iri.ddc@gmail.com'
#EMAIL_HOST_PASSWORD = ''
#EMAIL_PORT = 587 

EMAIL_USE_TLS = True
EMAIL_HOST = ''
EMAIL_HOST_USER = ''
EMAIL_HOST_PASSWORD = ''
EMAIL_PORT = 0 


ACCOUNT_ACTIVATION_DAYS = 7
REGISTRATION_OPEN = False

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 2

EMPTY_MEDIA_EXTERNALID = None

AUTO_INDEX_AFTER_SAVE = True

FRONT_TAG_LIST = [u"Enmi 2011", u"film", u"conférence"]

SECRET_KEY = env.str("DJANGO_SECRET")
