/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : TabletPlayButton.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Widget du bouton de lecture du player incorporé dans le Front pour le mode d'interaction pour tablettes.
 */

/*
 Ce Widget se superpose à la vidéo.
 * Est appelé dans les fichiers créant les widgets du metadataplayer.
 */
IriSP.Widgets.TabletPlayButton = function(player, config)
{
    IriSP.Widgets.Widget.call(this, player, config);
    // this.bindPopcorn("loadedmetadata","ready");
    this.paused = true;
    this.player = player;
    this.buttonWidth = 85;
    this.buttonHeight = 69;
};

/*
 * Constructeur du Widget.
*/
IriSP.Widgets.TabletPlayButton.prototype = new IriSP.Widgets.Widget();

/*
 * Fonction appelée pour dessiner le bouton.
*/
IriSP.Widgets.TabletPlayButton.prototype.draw = function()
{
    this.$playButton = IriSP.jQuery('<div>').attr("id", "tabletPlayButton");
    
    //On l'ajoute au widget.
    this.$.append(this.$playButton);
    this.$playButton.css(
    {
        position: 'absolute',
        width: this.player.config.gui.width,
        height: this.player.config.gui.height,
        'margin-top': -this.player.config.gui.height,
        'background-position': ((this.player.config.gui.width - this.buttonWidth)/2) + 'px ' + ((this.player.config.gui.height - this.buttonHeight)/2) + 'px'
    });
};

/*
 * Fonction appelée pour dessiner le bouton.
*/
IriSP.Widgets.TabletPlayButton.prototype.onPlayButtonTouchStart = function()
{
    if(this.paused)
    {
        this.paused = false;
        
        this.$playButton.css('opacity', '0');
        this.player.popcorn.play();
    }
}