﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : SwipeListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a effectué un swipe.
 * Il contient le code a être éxecuté au cas où cet événement survient.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Trakers.Tracking.Gestures;

namespace Trakers.MainModule.Events
{
    public class SwipeListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a effectué un swipe.
        */
        public void showAndSend(object o, SwipeEventArgs e)
        {
            String code = "";
            if (e.direction == SwipeDetector.Direction.LEFT)
                code = "SWIPE-LEFT";
            else
                code = "SWIPE-RIGHT";

            e.debug.showGesture(code);
            e.server.GesturePerformed(code);
        }
    }
}
