﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Postures
 * Classe : BendDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur s'est penché, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Postures
{
    public class BendDetector : PostureDetector
    {
        public BendDetector(DebugWindow _debug) : base(_debug)
        {
        }

        /*
         * Méthode de détection du penché.
         */
        public bool CheckForBend()
        {
            //Crée un état local afin de pouvoir analyser s'il y a une posture.
            List<Joint> localState = new List<Joint>(currentState);

            /*if (localState[(int)JointType.Head].Position.Z + 0.10 < localState[(int)JointType.ShoulderCenter].Position.Z)
                debug.onR0(true);
            else
                debug.onR0(false);
            if (localState[(int)JointType.ShoulderCenter].Position.Z + 0.20 < localState[(int)JointType.HipCenter].Position.Z)
                debug.onR1(true);
            else
                debug.onR1(false);
            if (Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeRight].Position.Z) < 0.20)
                debug.onR2(true);
            else
                debug.onR2(false);*/

            //Si la tête n'est pas plus proche d'au moins 20cm que les épaules
            //OU si les épaules ne sont pas plus proches d'au moins 20 cm que les hanches
            //OU si les hanches et les genoux ne sont pas au même niveau avec 20 cm d'erreur.
            //Alors on ne s'est pas penché.
            if (localState[(int)JointType.Head].Position.Z + 0.10 >= localState[(int)JointType.ShoulderCenter].Position.Z ||
            localState[(int)JointType.ShoulderCenter].Position.Z + 0.20 >= localState[(int)JointType.HipCenter].Position.Z ||
            Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeRight].Position.Z) > 0.20)
                return false;
            return true;
        }
    }
}
