import TUIO.*;
//import TrakersNavierStokes;
TuioProcessing tuioClient;
boolean oneHandLeft;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Création de la fenêtre et du client TUIO*/
void setup()
{
    size (640, 480);
    showMask();
    tuioClient = new TuioProcessing(this, 80);
    textAlign(CENTER);
    imageMode(CENTER);
    smooth();
}

/*FONCTION DE DESSIN
Entrée :
Sortie : Appel à la fonction de traitement d'input du serveur toutes les n millisecondes*/
void draw()
{
    fill(0);
    tuioInput();
    noStroke();
}

/*FONCTION DE RECEPTION DES MESSAGES OSC
Entrée :
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void tuioInput()
{
    noFill();
    //rect(0, 0, 50, 50);
  
    Vector tuioCursorList = tuioClient.getTuioCursors();

    if(tuioCursorList.size() <= 0)
    {
        showMask();
        text("Les mains sont trop loin ou trop près.", width/2 - 20, 20);
        text("Je ne détecte aucune main.", width/2 - 20, 40);
    }
        
    if(tuioCursorList.size() == 1)
    {
        handleOneHand((TuioCursor)tuioCursorList.elementAt(0));
        fill(255);
        text("Les mains sont dans la zone de captation.", width/2 - 20, 20);
        text("Je détecte une main.", width/2 - 20, 40);
    }
    else if(tuioCursorList.size() == 2)
    {
        handleBothHands(tuioCursorList);
        fill(255);
        text("Les mains sont dans la zone de captation.", width/2 - 20, 20);
        text("Je détecte les deux mains.", width/2 - 20, 40);
    }
}

/*FONCTION DE GENERATION DU MASQUE
Entrée :
Sortie : Place des rectangles autour de la zone de dessin*/
void showMask()
{
    background(0);
    fill(255);
    rect(0, 80, width, height-130);
}

/*FONCTION DE GESTION DES COURBES POUR UNE MAIN DETECTEE
Entrée : Un curseur TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleOneHand(TuioCursor handCursor)
{
    showMask();

    Vector pointList = handCursor.getPath();
    for (int j=0;j<pointList.size();j++)
    {
        TuioPoint pt = (TuioPoint)pointList.get(j);
        fill(0);
        drawEllipse(pt.getX(), pt.getY(), pt.getZ(), !oneHandLeft);
        
        if(tuioClient.getTuioCursors().size() == 2)
            break;
    }
}

/*FONCTION DE GESTION DES COURBES POUR DEUX MAINS DETECTEES
Entrée : La liste des curseurs TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleBothHands(Vector tuioCursorList)
{
    showMask();

    TuioCursor handLeftCursor = (TuioCursor)tuioCursorList.elementAt(0);
    TuioCursor rightLeftCursor = (TuioCursor)tuioCursorList.elementAt(1);
    Vector handLeftPointList = handLeftCursor.getPath();
    Vector handRightPointList = rightLeftCursor.getPath();
    TuioPoint pt;
    
    for(int j = 0, k = 0 ; j < handLeftPointList.size() || k < handRightPointList.size() ; j++, k++)
    {
        if(j < handLeftPointList.size())
        {
            pt = (TuioPoint)handLeftPointList.get(j);
            drawEllipse(pt.getX(), pt.getY(), pt.getZ(), true);
        }
        if(k < handRightPointList.size())
        {
            pt = (TuioPoint)handRightPointList.get(k);
            drawEllipse(pt.getX(), pt.getY(), pt.getZ(), false);
        }
        
        if(tuioCursorList.size() == 1)
        {
            if(j == handLeftPointList.size())
                oneHandLeft = false;
            else if(k == handRightPointList.size())
                oneHandLeft = true;
            //fill(0, 255, 0);
            break;
        }
    }
}

/*FONCTION DE DESSIN D'UN POINT DE COURBE
Entrée : Coordonnées X, Y et Z d'un point
Sortie : Le point est dessiné avec une épaisseur et une luminosité dépendant de Z*/
void drawEllipse(float x, float y, float z, boolean leftHand)
{

    fill(0, 0, 255);
    stroke(0,0,0);

    float weight = map(z, 1, 1.5, 50, 1);
    float redColor = map(z, 1, 1.5, 255, 80);
    
    if(leftHand)
        fill(redColor,0,0);
    else
        fill(0,redColor,0);
    
    if(weight < 30)
    {
        //strokeWeight(0);
    }
    else
    {
        fill(0, 0, redColor);
    }
    
    
    ellipse(x+20, y+100, weight, weight);
}
