﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Gestures
 * Classe : JumpDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur a sauté, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Gestures
{
    public class JumpDetector : GestureDetector
    {
        Debug.DebugWindow debug;
        static int n = 0;

        public JumpDetector(Debug.DebugWindow _d) : base()
        {
            debug = _d;
            gesturePeriod = (float)1;
            indexesPerSecond = 30;
            indexesToCheck = (int)(gesturePeriod * indexesPerSecond);
        }

        /*
         * Lit les noeuds de l'historique du squelette afin de détecter un Jump.
         * Règles :
         * .
         */
        public bool CheckForJump()
        {
            //Crée un historique de squelette local, puisque l'historique est mis à jour toutes les ~1/30 s.
            List<List<Joint>> localHistory = new List<List<Joint>>(history);
            
            //Si il n'y a pas assez de positions dans l'historique local pour vérifier le geste.
            if (localHistory.Count < indexesToCheck)
                return false;

            /* (HeadBelowBaseLine || LeftKneeBelowBaseLine || RightKneeBelowBaseLine ||
             * LeftAnkleBelowBaseLine || RightAnkleBelowBaseLine || BodyFaceUpwards
             * 
             * NOT
             * 
             * AND
             * 
             * HeadAboveBaseLine && LeftKneeAboveBaseLine && RightKneeAboveBaseLine &&
             * LegsStraightPreviouslyBent)
             * 
             * OR
             * 
             * HeadFarAboveBaseLine
             */

            //La distance de référence est ici la distance entre le milieu du dos et le milieu des épaules.
            refDistance = Math.Abs(localHistory[0][spineID].Position.Y - localHistory[0][shoulderCenterID].Position.Y);
            //On commence la position pour les indexesToCheck dernières postures (celle à l'index 0 étant la dernière).

            int beginIdx = localHistory.Count - indexesToCheck + 1;
            int middleIdx = localHistory.Count - indexesToCheck / 2;

            bool middleOK = true, topOfJump = false;

            

            //De la position p1 à pn, on suit l'algorithme.
            for (int i = beginIdx ; i < localHistory.Count ; i++)
            {

                if (localHistory[i][handRightID].Position.Y < localHistory[beginIdx][handRightID].Position.Y + refDistance &&
                   localHistory[i - 1][handRightID].Position.Y < localHistory[i][handRightID].Position.Y)
                {
                    topOfJump = true;
                    //Console.Out.WriteLine("TOP");
                }

                if (localHistory[i - 1][handRightID].Position.Y > localHistory[i][handRightID].Position.Y && !topOfJump)
                    return false;

                //Si la position Y de la main est plus haute que la tête
                //OU si la position Y de la main est plus basse que la hanche
                //OU si la nouvelle position Z de la main est moins profonde que la précédente
                //OU si la nouvelle position X de la main est plus éloignée de la distance N par rapport à la première position X
                //OU si la nouvelle position Y de la main est plus éloignée de la distance N par rapport à la première position Y
                //Alors la main en question ne fait pas de push.
                if (localHistory[i-1][handRightID].Position.Y > localHistory[i][handRightID].Position.Y &&
                    topOfJump || localHistory[i - 1][handRightID].Position.Y < localHistory[i][handRightID].Position.Y &&
                    !topOfJump)
                    return false;
            }

            //Console.Out.WriteLine("OK");

            //Si la distance en Z du geste a été plus courte que la distance N
            //Alors on retourne faux.
            //float dist = (localHistory[localHistory.Count - 1][handRightID].Position.X - localHistory[localHistory.Count - indexesToCheck][handRightID].Position.X);

            //Console.WriteLine(Math.Abs(localHistory[0][handLeftID].Position.Z - localHistory[localHistory.Count - indexesToCheck][handLeftID].Position.Z) * 100 + " " + refDistance);

            //Si la dernière position de la main droite/gauche est sur le côté gauche/droit du corps
            //OU si la première position calculée de la main droite/gauche est sur le côté gauche/droit du corps
            //Alors on retourne faux.
            
            //if(

            //On supprime l'historique local.
            //localHistory.Clear(Math.Abs(localHistory[i-1][handRightID].Position.Y));

            debug.ExceptionLbl.Background = System.Windows.Media.Brushes.Yellow;
            Console.WriteLine("{" + n++ + "}" + "JUMP");

            return false;
        }
    }
}
