﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : RightHandTrackedListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : La main droite est entrée dans le champ.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using System.Windows.Media.Media3D;

namespace Trakers.MainModule.Events
{
    public class RightHandTrackedListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : La main droite est entrée dans le champ.
        */
        public void showAndSend(object o, RightHandTrackedEventArgs e)
        {
            e.debug.showRightHandRect(true);
            Point3D pt = new Point3D(e.handJoint.Position.X, e.handJoint.Position.Y, e.handJoint.Position.Z);
            e.server.RightHandTracked(pt);
        }
    }
}
