﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : RightHandTrackedListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : La main droite est entrée dans le champ.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Events
{
    public class RightHandTrackedListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : La main droite est entrée dans le champ.
        */
        public void ShowOnScreen(object o, RightHandTrackedEventArgs e)
        {
            Joint handJoint = e.handJoint;
            //On l'indique dans le debug.
            e.debug.showRightHandRect(true);
            e.debug.showRightHandCoord("(" + handJoint.Position.X + ";" + handJoint.Position.Y + ")");
            //On notifie le serveur TUIO.
            e.server.RightHandTracked(o, e);
        }
    }
}
