/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

/*FONCTION DE RECEPTION DES MESSAGES OSC
Entrée :
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void tuioInput()
{
    noFill();
    Vector tuioCursorList = tuioClient.getTuioCursors();
    
    if(tuioCursorList.size() <= 0)
    {
        showMask();
        refreshText("Les mains sont trop loin ou trop près.", "Je ne détecte aucune main.");
    }
    		
    if(tuioCursorList.size() == 1)
    {
        handleOneHand((TuioCursor)tuioCursorList.elementAt(0));
        fill(255);
        refreshText("Les mains sont dans la zone de captation.", "Je détecte une main.");
    }
    else if(tuioCursorList.size() == 2)
    {
        handleBothHands(tuioCursorList);
        fill(255);
        refreshText("Les mains sont dans la zone de captation.", "Je détecte les deux mains.");
    }
}

/*FONCTION DE GESTION DES COURBES POUR UNE MAIN DETECTEE
Entrée : Un curseur TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleOneHand(TuioCursor handCursor)
{
    TuioPoint pt = handCursor.getPosition();//(TuioPoint)pointList.get(j);
    fill(0);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), !oneHandLeft);
}

/*FONCTION DE GESTION DES COURBES POUR DEUX MAINS DETECTEES
Entrée : La liste des curseurs TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleBothHands(Vector tuioCursorList)
{
    TuioCursor handLeftCursor = (TuioCursor)tuioCursorList.elementAt(0);
    TuioCursor handRightCursor = (TuioCursor)tuioCursorList.elementAt(1);
    TuioPoint pt;

    pt = (TuioPoint)handLeftCursor.getPosition();//handLeftPointList.get(j);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), true);
    pt = (TuioPoint)handRightCursor.getPosition();//handRightPointList.get(k);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), false);
}


