/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

/*Exemple tiré de processing.org*/

import TUIO.*;
TuioProcessing tuioClient;
int port = 80;
//Taille de la fenêtre
int WIDTH = 640, HEIGHT = 480;
float minDistHands = 1, maxDistHands = 1.5;
//Distance de "click" minimum/maximum avec la main.
float minClickHand = minDistHands+0.2, maxClickHand = maxDistHands-0.2;

void setup() {
  size(WIDTH, HEIGHT);
  tuioClient = new TuioProcessing(this, port);
  fill(126);
  background(102);
}

void draw() {
  tuioInput();
}

void crux(TuioPoint pt)
{
  if(pt.getZ() > minClickHand && pt.getZ() < maxClickHand) {
    stroke(255);
  } else {
    stroke(0);
  }
  line(pt.getX()-66, pt.getY(), pt.getX()+66, pt.getY());
  line(pt.getX(), pt.getY()-66, pt.getX(), pt.getY()+66); 
}
