﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : PushEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur a effectué un push.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;
using Trakers.Tracking.Gestures;

namespace Trakers.Tracking.Events
{
    public class PushEventArgs : EventArgs
    {
        //Fenêtre de debug.
        public readonly Debug.DebugWindow debug;
        //Serveur TUIO.
        public readonly Server server;
        //Direction du push.
        public readonly PushDetector.Direction direction;
        //Main ayant réalisé le push.
        public readonly PushDetector.Hand hand;

        /*
        * Constructeur : Il prend l'affichage de debug, le serveur TUIO et la direction du swipe.
        */
        public PushEventArgs(Debug.DebugWindow _debug, Server _server, PushDetector.Direction _direction, PushDetector.Hand _hand)
        {
            debug = _debug;
            server = _server;
            direction = _direction;
            hand = _hand;
        }
    }
}
