﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : ModChangeEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : On entre dans un nouveau mode.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;
using Trakers.Debug;

namespace Trakers.MainModule.Events
{
    public class ModChangeEventArgs : MainEventArgs
    {
        //Code du mode.
        public readonly String code;

        /*
        * Constructeur : Il prend l'affichage de debug et le serveur TUIO.
        */
        public ModChangeEventArgs(Server _server, DebugWindow _debug, String _code) : base(_server, _debug)
        {
            code = _code;
        }
    }
}
