﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : LeftHandQuitListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : La main gauche est sortie du champ.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Events
{
    public class LeftHandQuitListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : La main gauche est sortie du champ.
        */
        public void ShowOnScreen(object o, LeftHandQuitEventArgs e)
        {
            Joint handJoint = e.handJoint;
            //On l'indique dans le debug.
            e.debug.showLeftHandRect(false);
            e.debug.showLeftHandCoord("");
            e.debug.ExceptionLbl.Background = System.Windows.Media.Brushes.Transparent;
            //On notifie le serveur TUIO.
            e.server.LeftHandQuit(o, e);
        }
    }
}
