﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Debug
 * Classe : DebugParameters
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Code source attaché à la fenêtre de paramétrage du Middleware.
 * Celui-ci permet de charger/sauvegarder les paramètres stockés dans KinectMain.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Trakers.Tracking;
using System.Reflection;
using System.Resources;

namespace Trakers.Debug
{
    /// <summary>
    /// Interaction logic for DebugParameters.xaml
    /// </summary>
    public partial class DebugParameters : Window
    {
        //Membre d'accès à KinectMain.
        private KinectMain kinectMain;
        private ResourceManager rm;

        /*
         * Constructeur : On ouvre la fenêtre et on charge les paramètres.
         */
        public DebugParameters(KinectMain _kinectMain)
        {
            rm = new ResourceManager("Trakers.Properties.resources", Assembly.GetExecutingAssembly());
            kinectMain = _kinectMain;
            InitializeComponent();
            getParameters();
        }

        /*
         * Permet de charger les paramètres depuis KinectMain et les affiche dans la fenêtre de paramétrage.
         */
        public void getParameters()
        {
            searchMinDistanceTB.Text = kinectMain.getMinDistHands().ToString();
            searchMaxDistanceTB.Text = kinectMain.getMaxDistHands().ToString();
            connexionHostTB.Text = kinectMain.getConnexionHost();
            connexionPortTB.Text = kinectMain.getConnexionPort().ToString();
            timerElapsingTB.Text = kinectMain.getTimerElapsing().ToString();
        }

        /*
         * Permet de sauvegarder les paramètres de la fenêtre de paramétrage vers KinectMain.
         */
        public void setParameters()
        {
            try
            {
                ExceptionInParametersLbl.Content = "";

                float minDistHands = float.Parse(searchMinDistanceTB.Text);
                float maxDistHands = float.Parse(searchMaxDistanceTB.Text);
                int connexionPort = int.Parse(connexionPortTB.Text);
                int timerElapsing = int.Parse(timerElapsingTB.Text);

                if (maxDistHands <= 0 || minDistHands <= 0 || maxDistHands > 4 || minDistHands > 4 || minDistHands >= maxDistHands || connexionPort < 0 || timerElapsing < 0)
                {
                    ExceptionInParametersLbl.Content = rm.GetString("loadParametersIncorrect");
                }
                else
                {
                    kinectMain.setMinDistHands(minDistHands);
                    kinectMain.setMaxDistHands(maxDistHands);
                    kinectMain.setConnexionHost(connexionHostTB.Text);
                    kinectMain.setConnexionPort(connexionPort);
                    kinectMain.setTimerElapsing(timerElapsing);

                    kinectMain.updateParameters();
                }
            }
            catch (Exception)
            {
                //S'il y a eu un problème de parsing (i.e si l'utilisateur a entré une mauvaise valeur),
                //Alors on affiche l'erreur, puis on recharge les paramètres précédents.
                ExceptionInParametersLbl.Content = rm.GetString("loadParametersFail");
                getParameters();
            }
        }

        /*
         * Méthode attachée à l'événement click sur le bouton de validation de la fenêtre de paramétrage.
         * Les données sont sauvegardées vers KinectMain, puis rechargées dans la fenêtre.
         */
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            setParameters();
        }

        /*
         * Méthode appelée à la fermeture de la fenêtre de paramétrage.
         */
        private void Window_Closed(object sender, EventArgs e)
        {
            
        }
    }
}
