﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using Tuio;

namespace Tuio.Test
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private TuioServer _server;

        public MainWindow()
        {
            InitializeComponent();
            _server = new TuioServer();
            ThreadPool.QueueUserWorkItem(ThreadPoolCallback);
        }

        private void Window_MouseDown(object sender, MouseButtonEventArgs e)
        {
            _server.AddTuioCursor(0, AbsoluteToRelativePosition(e.GetPosition(this)));            
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            _server.UpdateTuioCursor(0, AbsoluteToRelativePosition(e.GetPosition(this)));
        }

        private void Window_MouseUp(object sender, MouseButtonEventArgs e)
        {
            _server.DeleteTuioCursor(0);
        }

        private System.Drawing.PointF AbsoluteToRelativePosition(Point p)
        {
            return new System.Drawing.PointF(
                (float)(p.X / Width),
                (float)(p.Y / Height));
        }

        private void ThreadPoolCallback(Object threadContext)
        {
            while (true)
            {
                _server.InitFrame();
                _server.CommitFrame();
                Thread.Sleep(25);
            }
        }
    }
}
