/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

import TUIO.TuioContainer;
import TUIO.TuioCursor;
import TUIO.TuioListener;
import TUIO.TuioObject;
import TUIO.TuioPoint;
import TUIO.TuioTime;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPortIn;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuioClient
implements OSCListener {
    private int port = 3333;
    private OSCPortIn oscPort;
    private boolean connected = false;
    private Hashtable<Long, TuioObject> objectList = new Hashtable();
    private Vector<Long> aliveObjectList = new Vector();
    private Vector<Long> newObjectList = new Vector();
    private Hashtable<Long, TuioCursor> cursorList = new Hashtable();
    private Vector<Long> aliveCursorList = new Vector();
    private Vector<Long> newCursorList = new Vector();
    private Vector<TuioObject> frameObjects = new Vector();
    private Vector<TuioCursor> frameCursors = new Vector();
    private Vector<TuioCursor> freeCursorList = new Vector();
    private int maxCursorID = -1;
    private long currentFrame = 0L;
    private TuioTime currentTime;
    private Vector<TuioListener> listenerList = new Vector();

    public TuioClient() {
    }

    public TuioClient(int n) {
        this.port = n;
    }

    public void connect() {
        TuioTime.initSession();
        this.currentTime = new TuioTime();
        this.currentTime.reset();
        try {
            this.oscPort = new OSCPortIn(this.port);
            this.oscPort.addListener("/tuio/2Dobj", this);
            this.oscPort.addListener("/tuio/2Dcur", this);
            this.oscPort.startListening();
            this.connected = true;
        }
        catch (Exception exception) {
            System.out.println("TuioClient: failed to connect to port " + this.port);
            this.connected = false;
        }
    }

    public void disconnect() {
        this.oscPort.stopListening();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oscPort.close();
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addTuioListener(TuioListener tuioListener) {
        this.listenerList.addElement(tuioListener);
    }

    public void removeTuioListener(TuioListener tuioListener) {
        this.listenerList.removeElement(tuioListener);
    }

    public void removeAllTuioListeners() {
        this.listenerList.clear();
    }

    public Vector<TuioObject> getTuioObjects() {
        return new Vector<TuioObject>(this.objectList.values());
    }

    public Vector<TuioCursor> getTuioCursors() {
        return new Vector<TuioCursor>(this.cursorList.values());
    }

    public TuioObject getTuioObject(long l) {
        return this.objectList.get(l);
    }

    public TuioCursor getTuioCursor(long l) {
        return this.cursorList.get(l);
    }

    @Override
    public void acceptMessage(Date date, OSCMessage oSCMessage) {
        Object[] objectArray = oSCMessage.getArguments();
        String string = (String)objectArray[0];
        String string2 = oSCMessage.getAddress();
        if (string2.equals("/tuio/2Dobj")) {
            if (string.equals("set")) {
                long l = ((Integer)objectArray[1]).longValue();
                int n = (Integer)objectArray[2];
                float f = ((Float)objectArray[3]).floatValue();
                float f2 = ((Float)objectArray[4]).floatValue();
                float f3 = ((Float)objectArray[5]).floatValue();
                float f4 = ((Float)objectArray[6]).floatValue();
                float f5 = ((Float)objectArray[7]).floatValue();
                float f6 = ((Float)objectArray[8]).floatValue();
                float f7 = ((Float)objectArray[9]).floatValue();
                float f8 = ((Float)objectArray[10]).floatValue();
                if (this.objectList.get(l) == null) {
                    TuioObject tuioObject = new TuioObject(l, n, f, f2, f3);
                    this.frameObjects.addElement(tuioObject);
                } else {
                    TuioObject tuioObject = this.objectList.get(l);
                    if (tuioObject == null) {
                        return;
                    }
                    if (tuioObject.xpos != f || tuioObject.ypos != f2 || tuioObject.angle != f3 || tuioObject.x_speed != f4 || tuioObject.y_speed != f5 || tuioObject.rotation_speed != f6 || tuioObject.motion_accel != f7 || tuioObject.rotation_accel != f8) {
                        TuioObject tuioObject2 = new TuioObject(l, n, f, f2, f3);
                        tuioObject2.update(f, f2, f3, f4, f5, f6, f7, f8);
                        this.frameObjects.addElement(tuioObject2);
                    }
                }
            } else if (string.equals("alive")) {
                int n;
                this.newObjectList.clear();
                for (n = 1; n < objectArray.length; ++n) {
                    long l = ((Integer)objectArray[n]).longValue();
                    this.newObjectList.addElement(l);
                    if (!this.aliveObjectList.contains(l)) continue;
                    this.aliveObjectList.removeElement(l);
                }
                for (n = 0; n < this.aliveObjectList.size(); ++n) {
                    TuioObject tuioObject = this.objectList.get(this.aliveObjectList.elementAt(n));
                    if (tuioObject == null) continue;
                    tuioObject.remove(this.currentTime);
                    this.frameObjects.addElement(tuioObject);
                }
            } else if (string.equals("fseq")) {
                long l = ((Integer)objectArray[1]).longValue();
                boolean bl = false;
                if (l > 0L) {
                    if (l > this.currentFrame) {
                        this.currentTime = TuioTime.getSessionTime();
                    }
                    if (l >= this.currentFrame || this.currentFrame - l > 100L) {
                        this.currentFrame = l;
                    } else {
                        bl = true;
                    }
                } else if (TuioTime.getSessionTime().subtract(this.currentTime).getTotalMilliseconds() > 100L) {
                    this.currentTime = TuioTime.getSessionTime();
                }
                if (!bl) {
                    Object object;
                    Enumeration<TuioObject> enumeration = this.frameObjects.elements();
                    block10: while (enumeration.hasMoreElements()) {
                        TuioObject tuioObject = enumeration.nextElement();
                        switch (tuioObject.getTuioState()) {
                            case 4: {
                                object = tuioObject;
                                ((TuioContainer)object).remove(this.currentTime);
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    TuioListener tuioListener = this.listenerList.elementAt(i);
                                    if (tuioListener == null) continue;
                                    tuioListener.removeTuioObject((TuioObject)object);
                                }
                                this.objectList.remove(((TuioContainer)object).getSessionID());
                                break;
                            }
                            case 0: {
                                TuioObject tuioObject3 = new TuioObject(this.currentTime, tuioObject.getSessionID(), tuioObject.getSymbolID(), tuioObject.getX(), tuioObject.getY(), tuioObject.getAngle());
                                this.objectList.put(tuioObject3.getSessionID(), tuioObject3);
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    TuioListener tuioListener = this.listenerList.elementAt(i);
                                    if (tuioListener == null) continue;
                                    tuioListener.addTuioObject(tuioObject3);
                                }
                                continue block10;
                            }
                            default: {
                                TuioObject tuioObject4 = this.objectList.get(tuioObject.getSessionID());
                                if (tuioObject.getX() != tuioObject4.getX() && tuioObject.getXSpeed() == 0.0f || tuioObject.getY() != tuioObject4.getY() && tuioObject.getYSpeed() == 0.0f) {
                                    tuioObject4.update(this.currentTime, tuioObject.getX(), tuioObject.getY(), tuioObject.getAngle());
                                } else {
                                    tuioObject4.update(this.currentTime, tuioObject.getX(), tuioObject.getY(), tuioObject.getAngle(), tuioObject.getXSpeed(), tuioObject.getYSpeed(), tuioObject.getRotationSpeed(), tuioObject.getMotionAccel(), tuioObject.getRotationAccel());
                                }
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    TuioListener tuioListener = this.listenerList.elementAt(i);
                                    if (tuioListener == null) continue;
                                    tuioListener.updateTuioObject(tuioObject4);
                                }
                                continue block10;
                            }
                        }
                    }
                    for (int i = 0; i < this.listenerList.size(); ++i) {
                        object = this.listenerList.elementAt(i);
                        if (object == null) continue;
                        object.refresh(new TuioTime(this.currentTime));
                    }
                    Vector<Long> vector = this.aliveObjectList;
                    this.aliveObjectList = this.newObjectList;
                    this.newObjectList = vector;
                }
                this.frameObjects.clear();
            }
        } else if (string2.equals("/tuio/2Dcur")) {
            if (string.equals("set")) {
                long l = ((Integer)objectArray[1]).longValue();
                float f = ((Float)objectArray[2]).floatValue();
                float f9 = ((Float)objectArray[3]).floatValue();
                float f10 = ((Float)objectArray[4]).floatValue();
                float f11 = ((Float)objectArray[5]).floatValue();
                float f12 = ((Float)objectArray[6]).floatValue();
                if (this.cursorList.get(l) == null) {
                    TuioCursor tuioCursor = new TuioCursor(l, -1, f, f9);
                    this.frameCursors.addElement(tuioCursor);
                } else {
                    TuioCursor tuioCursor = this.cursorList.get(l);
                    if (tuioCursor == null) {
                        return;
                    }
                    if (tuioCursor.xpos != f || tuioCursor.ypos != f9 || tuioCursor.x_speed != f10 || tuioCursor.y_speed != f11 || tuioCursor.motion_accel != f12) {
                        TuioCursor tuioCursor2 = new TuioCursor(l, tuioCursor.getCursorID(), f, f9);
                        tuioCursor2.update(f, f9, f10, f11, f12);
                        this.frameCursors.addElement(tuioCursor2);
                    }
                }
            } else if (string.equals("alive")) {
                int n;
                this.newCursorList.clear();
                for (n = 1; n < objectArray.length; ++n) {
                    long l = ((Integer)objectArray[n]).longValue();
                    this.newCursorList.addElement(l);
                    if (!this.aliveCursorList.contains(l)) continue;
                    this.aliveCursorList.removeElement(l);
                }
                for (n = 0; n < this.aliveCursorList.size(); ++n) {
                    TuioCursor tuioCursor = this.cursorList.get(this.aliveCursorList.elementAt(n));
                    if (tuioCursor == null) continue;
                    tuioCursor.remove(this.currentTime);
                    this.frameCursors.addElement(tuioCursor);
                }
            } else if (string.equals("fseq")) {
                long l = ((Integer)objectArray[1]).longValue();
                boolean bl = false;
                if (l > 0L) {
                    if (l > this.currentFrame) {
                        this.currentTime = TuioTime.getSessionTime();
                    }
                    if (l >= this.currentFrame || this.currentFrame - l > 100L) {
                        this.currentFrame = l;
                    } else {
                        bl = true;
                    }
                } else if (TuioTime.getSessionTime().subtract(this.currentTime).getTotalMilliseconds() > 100L) {
                    this.currentTime = TuioTime.getSessionTime();
                }
                if (!bl) {
                    Object object;
                    Enumeration<TuioCursor> enumeration = this.frameCursors.elements();
                    block17: while (enumeration.hasMoreElements()) {
                        TuioCursor tuioCursor = enumeration.nextElement();
                        switch (tuioCursor.getTuioState()) {
                            case 4: {
                                Object object2;
                                object = tuioCursor;
                                ((TuioContainer)object).remove(this.currentTime);
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    object2 = this.listenerList.elementAt(i);
                                    if (object2 == null) continue;
                                    object2.removeTuioCursor((TuioCursor)object);
                                }
                                this.cursorList.remove(((TuioContainer)object).getSessionID());
                                if (((TuioCursor)object).getCursorID() == this.maxCursorID) {
                                    this.maxCursorID = -1;
                                    if (this.cursorList.size() > 0) {
                                        Enumeration<TuioCursor> enumeration2 = this.cursorList.elements();
                                        while (enumeration2.hasMoreElements()) {
                                            int n = enumeration2.nextElement().getCursorID();
                                            if (n <= this.maxCursorID) continue;
                                            this.maxCursorID = n;
                                        }
                                        object2 = this.freeCursorList.elements();
                                        while (object2.hasMoreElements()) {
                                            int n = object2.nextElement().getCursorID();
                                            if (n < this.maxCursorID) continue;
                                            this.freeCursorList.removeElement(n);
                                        }
                                        continue block17;
                                    }
                                    this.freeCursorList.clear();
                                    break;
                                }
                                if (((TuioCursor)object).getCursorID() >= this.maxCursorID) continue block17;
                                this.freeCursorList.addElement((TuioCursor)object);
                                break;
                            }
                            case 0: {
                                Object object2;
                                int n = this.cursorList.size();
                                if (this.cursorList.size() <= this.maxCursorID && this.freeCursorList.size() > 0) {
                                    object2 = this.freeCursorList.firstElement();
                                    Enumeration<TuioCursor> enumeration3 = this.freeCursorList.elements();
                                    while (enumeration3.hasMoreElements()) {
                                        TuioCursor tuioCursor3 = enumeration3.nextElement();
                                        if (!(tuioCursor3.getDistance(tuioCursor) < ((TuioPoint)object2).getDistance(tuioCursor))) continue;
                                        object2 = tuioCursor3;
                                    }
                                    n = ((TuioCursor)object2).getCursorID();
                                    this.freeCursorList.removeElement(object2);
                                } else {
                                    this.maxCursorID = n;
                                }
                                object2 = new TuioCursor(this.currentTime, tuioCursor.getSessionID(), n, tuioCursor.getX(), tuioCursor.getY());
                                this.cursorList.put(((TuioContainer)object2).getSessionID(), (TuioCursor)object2);
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    TuioListener tuioListener = this.listenerList.elementAt(i);
                                    if (tuioListener == null) continue;
                                    tuioListener.addTuioCursor((TuioCursor)object2);
                                }
                                continue block17;
                            }
                            default: {
                                TuioCursor tuioCursor4 = this.cursorList.get(tuioCursor.getSessionID());
                                if (tuioCursor.getX() != tuioCursor4.getX() && tuioCursor.getXSpeed() == 0.0f || tuioCursor.getY() != tuioCursor4.getY() && tuioCursor.getYSpeed() == 0.0f) {
                                    tuioCursor4.update(this.currentTime, tuioCursor.getX(), tuioCursor.getY());
                                } else {
                                    tuioCursor4.update(this.currentTime, tuioCursor.getX(), tuioCursor.getY(), tuioCursor.getXSpeed(), tuioCursor.getYSpeed(), tuioCursor.getMotionAccel());
                                }
                                for (int i = 0; i < this.listenerList.size(); ++i) {
                                    TuioListener tuioListener = this.listenerList.elementAt(i);
                                    if (tuioListener == null) continue;
                                    tuioListener.updateTuioCursor(tuioCursor4);
                                }
                                continue block17;
                            }
                        }
                    }
                    for (int i = 0; i < this.listenerList.size(); ++i) {
                        object = this.listenerList.elementAt(i);
                        if (object == null) continue;
                        object.refresh(new TuioTime(this.currentTime));
                    }
                    Vector<Long> vector = this.aliveCursorList;
                    this.aliveCursorList = this.newCursorList;
                    this.newCursorList = vector;
                }
                this.frameCursors.clear();
            }
        }
    }
}

