﻿/*
 * Projet : KINECT PROJECTS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking
 * Classe : LeftHandTrackedListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : La main gauche est entrée dans le champ.
 * Il contient le code a être éxecuté au cas cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Events
{
    public class LeftHandTrackedListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : La main gauche est entrée dans le champ.
        */
        public void ShowOnScreen(object o, LeftHandTrackedEventArgs e)
        {
            Joint handJoint = e.handJoint;
            //On l'indique dans le debug.
            e.debug.showLeftHandRect(true);
            e.debug.showLeftHandCoord("(" + handJoint.Position.X + ";" + handJoint.Position.Y + ")");
            //On notifie le serveur TUIO.
            e.server.LeftHandTracked(o, e);
        }
    }
}
