/*
 * Decompiled with CFR 0.152.
 */
import TUIO.TuioClient;
import TUIO.TuioListener;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class TuioDemo {
    private final int window_width = 640;
    private final int window_height = 480;
    private boolean fullscreen = false;
    private TuioDemoComponent demo = new TuioDemoComponent();
    private JFrame frame;
    private GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();

    public TuioDemo() {
        this.setupWindow();
        this.showWindow();
    }

    public TuioListener getTuioListener() {
        return this.demo;
    }

    public void setupWindow() {
        this.frame = new JFrame();
        this.frame.add(this.demo);
        this.frame.setTitle("TuioDemo");
        this.frame.setResizable(false);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.frame.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    System.exit(0);
                } else if (keyEvent.getKeyCode() == 112) {
                    TuioDemo.this.destroyWindow();
                    TuioDemo.this.setupWindow();
                    TuioDemo.this.fullscreen = !TuioDemo.this.fullscreen;
                    TuioDemo.this.showWindow();
                } else if (keyEvent.getKeyCode() == 86) {
                    ((TuioDemo)TuioDemo.this).demo.verbose = !((TuioDemo)TuioDemo.this).demo.verbose;
                }
            }
        });
    }

    public void destroyWindow() {
        this.frame.setVisible(false);
        if (this.fullscreen) {
            this.device.setFullScreenWindow(null);
        }
        this.frame = null;
    }

    public void showWindow() {
        if (this.fullscreen) {
            int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            this.demo.setSize(n, n2);
            this.frame.setSize(n, n2);
            this.frame.setUndecorated(true);
            this.device.setFullScreenWindow(this.frame);
        } else {
            int n = 640;
            int n3 = 480;
            this.demo.setSize(n, n3);
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            this.frame.setSize(n, n3 + insets.top);
        }
        this.frame.setVisible(true);
        this.frame.repaint();
    }

    public static void main(String[] stringArray) {
        TuioDemo tuioDemo = new TuioDemo();
        TuioClient tuioClient = null;
        switch (stringArray.length) {
            case 1: {
                try {
                    tuioClient = new TuioClient(Integer.parseInt(stringArray[0]));
                }
                catch (Exception exception) {
                    System.out.println("usage: java TuioDemo [port]");
                    System.exit(0);
                }
                break;
            }
            case 0: {
                tuioClient = new TuioClient();
                break;
            }
            default: {
                System.out.println("usage: java TuioDemo [port]");
                System.exit(0);
            }
        }
        if (tuioClient != null) {
            tuioClient.addTuioListener(tuioDemo.getTuioListener());
            tuioClient.connect();
        } else {
            System.out.println("usage: java TuioDemo [port]");
            System.exit(0);
        }
    }
}

