/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

public class TuioTime {
    private long seconds = 0L;
    private long micro_seconds = 0L;
    private static long start_seconds = 0L;
    private static long start_micro_seconds = 0L;

    public TuioTime() {
        this.seconds = 0L;
        this.micro_seconds = 0L;
    }

    public TuioTime(long l) {
        this.seconds = l / 1000L;
        this.micro_seconds = 1000L * (l % 1000L);
    }

    public TuioTime(long l, long l2) {
        this.seconds = l;
        this.micro_seconds = l2;
    }

    public TuioTime(TuioTime tuioTime) {
        this.seconds = tuioTime.getSeconds();
        this.micro_seconds = tuioTime.getMicroseconds();
    }

    public TuioTime add(long l) {
        long l2 = this.seconds + l / 1000000L;
        long l3 = this.micro_seconds + l % 1000000L;
        return new TuioTime(l2, l3);
    }

    public TuioTime add(TuioTime tuioTime) {
        long l = this.seconds + tuioTime.getSeconds();
        long l2 = this.micro_seconds + tuioTime.getMicroseconds();
        l += l2 / 1000000L;
        return new TuioTime(l, l2 %= 1000000L);
    }

    public TuioTime subtract(long l) {
        long l2 = this.seconds - l / 1000000L;
        long l3 = this.micro_seconds - l % 1000000L;
        if (l3 < 0L) {
            l3 += 1000000L;
            --l2;
        }
        return new TuioTime(l2, l3);
    }

    public TuioTime subtract(TuioTime tuioTime) {
        long l = this.seconds - tuioTime.getSeconds();
        long l2 = this.micro_seconds - tuioTime.getMicroseconds();
        if (l2 < 0L) {
            l2 += 1000000L;
            --l;
        }
        return new TuioTime(l, l2);
    }

    public boolean equals(TuioTime tuioTime) {
        return this.seconds == tuioTime.getSeconds() && this.micro_seconds == tuioTime.getMicroseconds();
    }

    public void reset() {
        this.seconds = 0L;
        this.micro_seconds = 0L;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMicroseconds() {
        return this.micro_seconds;
    }

    public long getTotalMilliseconds() {
        return this.seconds * 1000L + this.micro_seconds / 1000L;
    }

    public static void initSession() {
        TuioTime tuioTime = TuioTime.getSystemTime();
        start_seconds = tuioTime.getSeconds();
        start_micro_seconds = tuioTime.getMicroseconds();
    }

    public static TuioTime getSessionTime() {
        TuioTime tuioTime = TuioTime.getSystemTime().subtract(TuioTime.getStartTime());
        return tuioTime;
    }

    public static TuioTime getStartTime() {
        return new TuioTime(start_seconds, start_micro_seconds);
    }

    public static TuioTime getSystemTime() {
        long l = System.nanoTime() / 1000L;
        return new TuioTime(l / 1000000L, l % 1000000L);
    }
}

