/*
 * Decompiled with CFR 0.152.
 */
package TUIO;

import TUIO.TuioTime;

public class TuioPoint {
    protected float xpos;
    protected float ypos;
    protected TuioTime currentTime;
    protected TuioTime startTime;

    public TuioPoint() {
        this.xpos = 0.0f;
        this.ypos = 0.0f;
        this.currentTime = TuioTime.getSessionTime();
        this.startTime = new TuioTime(this.currentTime);
    }

    public TuioPoint(float f, float f2) {
        this.xpos = f;
        this.ypos = f2;
        this.currentTime = TuioTime.getSessionTime();
        this.startTime = new TuioTime(this.currentTime);
    }

    public TuioPoint(TuioPoint tuioPoint) {
        this.xpos = tuioPoint.getX();
        this.ypos = tuioPoint.getY();
        this.currentTime = TuioTime.getSessionTime();
        this.startTime = new TuioTime(this.currentTime);
    }

    public TuioPoint(TuioTime tuioTime, float f, float f2) {
        this.xpos = f;
        this.ypos = f2;
        this.currentTime = new TuioTime(tuioTime);
        this.startTime = new TuioTime(this.currentTime);
    }

    public void update(TuioPoint tuioPoint) {
        this.xpos = tuioPoint.getX();
        this.ypos = tuioPoint.getY();
    }

    public void update(float f, float f2) {
        this.xpos = f;
        this.ypos = f2;
    }

    public void update(TuioTime tuioTime, float f, float f2) {
        this.xpos = f;
        this.ypos = f2;
        this.currentTime = new TuioTime(tuioTime);
    }

    public float getX() {
        return this.xpos;
    }

    public float getY() {
        return this.ypos;
    }

    public float getDistance(float f, float f2) {
        float f3 = this.xpos - f;
        float f4 = this.ypos - f2;
        return (float)Math.sqrt(f3 * f3 + f4 * f4);
    }

    public float getDistance(TuioPoint tuioPoint) {
        return this.getDistance(tuioPoint.getX(), tuioPoint.getY());
    }

    public float getAngle(float f, float f2) {
        float f3 = this.xpos - f;
        float f4 = this.ypos - f2;
        float f5 = this.getDistance(f, f2);
        float f6 = (float)(Math.asin(f3 / f5) + 1.5707963267948966);
        if (f4 < 0.0f) {
            f6 = (float)Math.PI * 2 - f6;
        }
        return f6;
    }

    public float getAngle(TuioPoint tuioPoint) {
        return this.getAngle(tuioPoint.getX(), tuioPoint.getY());
    }

    public float getAngleDegrees(float f, float f2) {
        return this.getAngle(f, f2) / (float)Math.PI * 180.0f;
    }

    public float getAngleDegrees(TuioPoint tuioPoint) {
        return this.getAngle(tuioPoint) / (float)Math.PI * 180.0f;
    }

    public int getScreenX(int n) {
        return Math.round(this.xpos * (float)n);
    }

    public int getScreenY(int n) {
        return Math.round(this.ypos * (float)n);
    }

    public TuioTime getTuioTime() {
        return new TuioTime(this.currentTime);
    }

    public TuioTime getStartTime() {
        return new TuioTime(this.startTime);
    }
}

