/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

import TUIO.*;
TuioProcessing tuioClient;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Création de la fenêtre et du client TUIO*/
void setup()
{
    size (640, 480);
    showMask();
    tuioClient = new TuioProcessing(this, 8080);
    textAlign(CENTER);
    imageMode(CENTER);
    smooth();
}

/*FONCTION DE DESSIN
Entrée :
Sortie : Appel à la fonction de traitement d'input du serveur toutes les n millisecondes*/
void draw()
{
    fill(0);
    tuioInput();
    noStroke();
}

/*FONCTION DE GENERATION DU MASQUE
Entrée :
Sortie : Place des rectangles autour de la zone de dessin*/
void showMask()
{
    background(0);
    fill(255);
    rect(0, 80, width, height-130);
}

/*FONCTION D'AFFICHAGE DU CODE DE LA GESTURE DETECTEE
Entree :
Sortie : Affichage du code de la gesture*/
void showGestureMessage(TuioString tstr)
{
    text("Gesture détectée : " + tstr.getMessage(), width/2 - 20, 20);
}

