/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : mosaic.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" courbe et définit des fonctions d'intéractions (dessin...).
 */
 
function curve()
{
	tool.fixedDistance = 10;
	this.path;
	this.pathStroke;
	this.lastPoint;
}

curve.prototype.onMouseDown = function(event)
{
	this.pathStroke = new Path();
	this.path = new Path();
	
	this.pathStroke.fillColor = '#366F7A';
	this.path.fillColor = '#02FEFF';
	
	console.log('down');
};

curve.prototype.onMouseDrag = function(event)
{
	//if(event.point.x < 0 || event.point.x > canvasWidth || event.point.y < 0 || event.point.y > canvasHeight)
		//return;
	
	var step = event.delta / 5;
	var stepStroke = event.delta / 3;
	step.angle += 90;
	stepStroke.angle += 90;

	var top = event.point + step;
	var bottom = event.point - step;
	
	var topStroke = event.point + stepStroke;
	var bottomStroke = event.point - stepStroke;

	this.path.add(top);
	this.path.insert(0, bottom);
	this.path.smooth();
	
	this.pathStroke.add(topStroke);
	this.pathStroke.insert(0, bottomStroke);
	this.pathStroke.smooth();
	
	this.lastPoint = event.middlePoint;
};

curve.prototype.onMouseUp = function(event)
{
	this.pathStroke.remove();
	this.path.remove();
};

curve.prototype.onKeyDown = function(event)
{
	//S'il n'y a rien a colorier, on quitte.
	if(typeof this.pathStroke === 'undefined' || typeof this.path === 'undefined')
		return;
	
	if(event.key == 'r' || event.key == 'R')
	{
		this.pathStroke.fillColor = '#49564F';
		this.path.fillColor = '#00FE00'
	}
	else if(event.key == 'x' || event.key == 'X')
	{
		this.pathStroke.fillColor = '#535F6D';
		this.path.fillColor = '#CCCCCC'
	}
	else if(event.key == 'w' || event.key == 'W')
	{
		this.pathStroke.fillColor = '#366F7A';
		this.path.fillColor = '#02FEFF'
	}
};