/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Communication
 * Classe : Server
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Reçoit des notifications du module sous-module Tracking.
 * Centralise les deux serveurs TUIO et WS et permettent aux autres modules de faire appel
 * à eux via cette classe.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media.Media3D;

namespace Trakers.Communication
{
    public class Server
    {
        private TUIOServer TUIOserver;
        private WSServer WSserver;

        /*
         * Constructeur. Il prend les paramètres des deux serveurs.
         */
        public Server(String tuioHost, int tuioPort, int _tuioTimerElapsing, String wsHost, int wsPort, int _wsTimerElapsing)
        {
            TUIOserver = new TUIOServer(wsHost, tuioPort, _tuioTimerElapsing);
            WSserver = new WSServer(wsHost, wsPort, _wsTimerElapsing);
        }

        /*
        * Méthode appelée lors d'une notification de type : main gauche entrée dans le champ.
        */
        public void LeftHandTracked(Point3D pt)
        {
            TUIOserver.LeftHandTracked(pt);
            WSserver.LeftHandTracked(pt);
        }

        /*
        * Méthode appelée lors d'une notification de type : main droite entrée dans le champ.
        */
        public void RightHandTracked(Point3D pt)
        {
            TUIOserver.RightHandTracked(pt);
            WSserver.RightHandTracked(pt);
        }

        /*
        * Méthode appelée lors d'une notification de type : main gauche sortie du champ.
        */
        public void LeftHandQuit()
        {
            TUIOserver.LeftHandQuit();
            WSserver.LeftHandQuit();
        }

        /*
        * Méthode appelée lors d'une notification de type : main droite sortie du champ.
        */
        public void RightHandQuit()
        {
            TUIOserver.RightHandQuit();
            WSserver.RightHandQuit();
        }

        /*
        * Méthode appelée lorsqu'une gesture a été détectée et que l'événement approprié a été lancé.
        */
        public void GesturePerformed(String code)
        {
            TUIOserver.GesturePerformed(code);
            WSserver.GesturePerformed(code);
        }

        /*
        * Méthode appelée lorsqu'on doit entrer dans un autre mode.
        */
        public void ModeNotification(String code)
        {
            TUIOserver.ModeNotification(code);
            WSserver.ModeNotification(code);
        }
    }
}
