﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : PushListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a effectué un push.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.Tracking.Events
{
    public class PushListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a effectué un push.
        */
        public void ShowOnScreen(object o, PushEventArgs e)
        {
            //On l'indique dans le debug.
            //Lorsqu'il s'agit d'un push/pull de la main gauche/droite/deux deux on envoie le message
            //correspondant.
            if (e.direction == Gestures.PushDetector.Direction.PUSH)
            {
                if (e.hand == Gestures.PushDetector.Hand.RIGHT)
                    e.debug.showGesture("PUSH-RIGHT");
                else if (e.hand == Gestures.PushDetector.Hand.LEFT)
                    e.debug.showGesture("PUSH-LEFT");
                else
                    e.debug.showGesture("PUSH-BOTH");
            }
            else
            {
                if (e.hand == Gestures.PushDetector.Hand.RIGHT)
                    e.debug.showGesture("PULL-RIGHT");
                else if (e.hand == Gestures.PushDetector.Hand.LEFT)
                    e.debug.showGesture("PULL-LEFT");
                else
                    e.debug.showGesture("PULL-BOTH");
            }
            //On notifie le serveur TUIO.
            e.server.Push(o, e);
        }
    }
}
