/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

// smoke2 by Glen Murphy.
// View the applet in use at http://bodytag.org/
// Code has not been optimised, and will run fairly slowly.

import TUIO.*;
TuioProcessing tuioClient;

int realWidth = 640, realHeight = 480-200;
int WIDTH = 300;
int HEIGHT = 300;

//Port du Client TUIO.
int port = 80;
//Limites de la zone de recherche pour les mains.
float minDistHands = 1;
float maxDistHands = 1.5;

int RES = 2;
int PENSIZE = 30;

int lwidth = WIDTH/RES;
int lheight = HEIGHT/RES;
int PNUM = 30000;
vsquare[][] v = new vsquare[lwidth+1][lheight+1];
vbuffer[][] vbuf = new vbuffer[lwidth+1][lheight+1];

TuioPoint pt1, pt2, precPt1, precPt2;

particle[] p = new particle[PNUM];
int pcount = 0;
int mouse1Xvel = 0;
int mouse1Yvel = 0;
int mouse2Xvel = 0;
int mouse2Yvel = 0;

int randomGust = 0;
int randomGustMax;
float randomGustX;
float randomGustY;
float randomGustSize;
float randomGustXvel;
float randomGustYvel;

void setup() {
  size(WIDTH,HEIGHT);
  tuioClient = new TuioProcessing(this, port);
  background(#cccccc);
  noStroke();
  for(int i = 0; i < PNUM; i++) {
    p[i] = new particle(random(WIDTH/2-20,WIDTH/2+20),random(HEIGHT-20,HEIGHT));
  }
  for(int i = 0; i <= lwidth; i++) {
    for(int u = 0; u <= lheight; u++) {
      v[i][u] = new vsquare(i*RES,u*RES);
      vbuf[i][u] = new vbuffer(i*RES,u*RES);
    }
  }
}

void draw() {
  tuioInput();
  
  int a1xvel = 0, a1yvel = 0, a2xvel = 0, a2yvel = 0;
  if(precPt1 != null && pt1 != null)
  {
    float X1Rev = map(pt1.getX(), realWidth, realHeight, WIDTH, HEIGHT);
    float Y1Rev = map(pt1.getY(), realWidth, realHeight, WIDTH, HEIGHT);
    float X1PrecRev = map(precPt1.getX(), realWidth, realHeight, WIDTH, HEIGHT);
    float Y1PrecRev = map(precPt1.getY(), realWidth, realHeight, WIDTH, HEIGHT);
    a1xvel = (int)X1Rev-(int)X1PrecRev;
    a1yvel = (int)Y1Rev-(int)Y1PrecRev;
    mouse1Xvel = (a1xvel != mouse1Xvel) ? a1xvel : 0;
    mouse1Yvel = (a1yvel != mouse1Yvel) ? a1yvel : 0;
  }
  if(precPt2 != null && pt2 != null)
  {
    float X2Rev = map(pt2.getX(), realWidth, realHeight, WIDTH, HEIGHT);
    float Y2Rev = map(pt2.getY(), realWidth, realHeight, WIDTH, HEIGHT);
    float X2PrecRev = map(precPt2.getX(), realWidth, realHeight, WIDTH, HEIGHT);
    float Y2PrecRev = map(precPt2.getY(), realWidth, realHeight, WIDTH, HEIGHT);
    a2xvel = (int)X2Rev-(int)X2PrecRev;
    a2yvel = (int)Y2Rev-(int)Y2PrecRev;
    mouse2Xvel = (a2xvel != mouse2Xvel) ? a2xvel : 0;
    mouse2Yvel = (a2yvel != mouse2Yvel) ? a2yvel : 0;
  }
  
  if(randomGust <= 0) {
    if(random(0,10)<1) {
      randomGustMax = (int)random(5,12);
      randomGust = randomGustMax;
      randomGustX = random(0,WIDTH);
      randomGustY = random(0,HEIGHT-10);
      randomGustSize = random(0,50);
      if(randomGustX > WIDTH/2) randomGustXvel = random(-8,0);
      else randomGustXvel = random(0,8);
      randomGustYvel = random(-2,1);
    }
    randomGust--;
  }
  
  for(int i = 0; i < lwidth; i++) {
    for(int u = 0; u < lheight; u++) {
      vbuf[i][u].updatebuf(i,u);
      v[i][u].col = 0;
    }
  }
  for(int i = 0; i < PNUM-1; i++) {
    p[i].updatepos();
  }
  for(int i = 0; i < lwidth; i++) {
    for(int u = 0; u < lheight; u++) {
      v[i][u].addbuffer(i, u);
      v[i][u].updatevels(mouse1Xvel, mouse1Yvel, pt1);
      if(pt2 != null)
        v[i][u].updatevels(mouse2Xvel, mouse2Yvel, pt2);
      v[i][u].display(i, u);
    }
  }
  randomGust = 0;
}

void update(TuioPoint _pt1, TuioPoint _pt2)
{
  pt1 = _pt1;
  pt2 = _pt2;
}
