/* ===============================================
 *												   *
 *		      ZONE DES NOTIFICATIONS			   *
 *												   *
   =============================================== */

/*
 * Affiche l'aide.
*/
mosaic.prototype.notifyHelp = function(inMosaic)
{
	if(this.helpDisplayed)
	{
		return;
	}
	
	this.removeSelectionSearchMosaicFull();
	this.removePointMosaicPrezoom();
	
	this.helpDisplayed = true;
	
	var search_2hands_tab = ['arret', 'contact', 'grandjete', 'group_spin', 'port_de_bras', 'rythme', 'slow', 'spin', 'up_down', 'wave'];
	var search_2hands_tab_opacities = [0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5];
	var search_body_tab = ['chute', 'knee_up', 'jump', 'bend'];
	var search_body_tab_opacities = [1, 1, 1, 1];
	var controls_1hand_tab;
	var controls_1hand_tab_1;
	var controls_1hand_tab_2;
	var controls_1hand_tab_opacities;
	var controls_1hand_tab_opacities_1;
	var controls_1hand_tab_opacities_2;
	
	if(inMosaic)
	{
		controls_1hand_tab = ['selection'];
		controls_1hand_tab_opacities = [1];
	}
	else
	{
		controls_1hand_tab_1 = ['deplacer', 'precedent', 'suivant', 'mosaique_horizontal', 'mosaique_vertical'];
		controls_1hand_tab_2 = ['move_down', 'move_up', 'move_right', 'move_left'];
		controls_1hand_tab_opacities_1 = [1, 1, 1, 1, 1];
		controls_1hand_tab_opacities_2 = [1, 1, 1, 1];
	}
	
	//On spécifie les notifications en div.
	var search_title = "<div id='search_title'></div>";
	var search_img = "<div id='search_img' class='notify_imgs'></div>";
	var search_2hands_text = "<div id='search_2hands_text'></div>";
	var search_2hands_imgs = "<div id='search_2hands_imgs' class='notify_imgs_big'>";
	
	for(var i = 0 ; i < search_2hands_tab.length ; i++)
	{
		search_2hands_imgs += "<div id='2hands_" + search_2hands_tab[i] + "' class='notify_imgs_small' style='opacity: " + search_2hands_tab_opacities[i] + ";'></div>";
	}
	search_2hands_imgs += "</div>";
	
	var search_body_text = "<div id='search_body_text'></div>";
	var search_body_imgs = "<div id='search_body_imgs' class='notify_imgs'>"
	
	for(var i = 0 ; i < search_body_tab.length ; i++)
	{
		search_body_imgs += "<div id='body_" + search_body_tab[i] + "' class='notify_imgs_small' style='opacity: " + search_body_tab_opacities[i] + ";'></div>";
	}
	search_body_imgs += "</div>";
	
	var controls_title = "<div id='controls_title'></div>";
	var controls_img = "<div id='controls_img' class='notify_imgs'></div>";
	var controls_1hand_text = "<div id='controls_1hand_text'></div>";
	var controls_1hand_imgs;
	var controls_1hand_imgs_1;
	var controls_1hand_imgs_2;
	
	if(inMosaic)
	{
		controls_1hand_imgs = "<div id='controls_1hand_imgs' class='notify_imgs'>";
		for(var i = 0 ; i < controls_1hand_tab.length ; i++)
		{
			controls_1hand_imgs += "<div id='1hand_" + controls_1hand_tab[i] + "' class='notify_imgs_small' style='opacity: " + controls_1hand_tab_opacities[i] + ";'></div>";
		}
		controls_1hand_imgs += "</div>";
	}
	else
	{
		controls_1hand_imgs_1 = "<div id='controls_1hand_imgs_1' class='notify_imgs'>";
		controls_1hand_imgs_2 = "<div id='controls_1hand_imgs_2' class='notify_imgs'>";
		for(var i = 0 ; i < controls_1hand_tab_1.length ; i++)
		{
			controls_1hand_imgs_1 += "<div id='1hand_" + controls_1hand_tab_1[i] + "' class='notify_imgs_small' style='opacity: " + controls_1hand_tab_opacities_1[i] + ";'></div>";
		}
		controls_1hand_imgs_1 += "</div>";
		for(var i = 0 ; i < controls_1hand_tab_2.length ; i++)
		{
			controls_1hand_imgs_2 += "<div id='1hand_" + controls_1hand_tab_2[i] + "' class='notify_imgs_small' style='opacity: " + controls_1hand_tab_opacities_2[i] + ";'></div>";
		}
		controls_1hand_imgs_2 += "</div>";
	}
	
	var help_search = "<div id='help_search'>" + search_title + search_img + search_2hands_text + search_2hands_imgs + search_body_text + search_body_imgs + "</div>";
	var help_controls;

	if(inMosaic)
	{
		help_controls = "<div id='help_controls'>" + controls_title + controls_img + controls_1hand_text + controls_1hand_imgs + "</div>";
	}
	else
	{
		help_controls = "<div id='help_controls'>" + controls_title + controls_img + controls_1hand_text + controls_1hand_imgs_1 + controls_1hand_imgs_2 + "</div>";
	}
	
	var notification_help = "<div id='notify_help'>" + help_search + "<div id='help_sep'></div>" + help_controls + "</div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_help);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $(window).width(), notify_height = $(window).height();
	var notify_margin = parseInt($('#notify_help').css('margin'));
	var notify_ = 10;
	
	//On les positionne.
	$('#notify_help').css(
	{
		left: "0px",
		top: "0px",
		width: notify_width - notify_margin * 2,
		height: notify_height - notify_margin * 2,
		'z-index': 2000
	});
	
	// console.log(($('#help_search').width() - ($('.notify_imgs_small').width() * 5 + parseInt($('.notify_imgs_small').css('margin')))) / 2);
	
	$('#search_2hands_imgs').css(
	{
		'padding-left': ($('#help_search').width() - ($('.notify_imgs_small').width() * 5 + parseInt($('.notify_imgs_small').css('margin')))) / 2,
		'height': ($('.notify_imgs_small').height() * 2 + parseInt($('.notify_imgs_small').css('margin')))
	});
	
	$('#search_body_imgs').css(
	{
		'padding-left': ($('#help_search').width() - ($('.notify_imgs_small').width() * 4 + parseInt($('.notify_imgs_small').css('margin')))) / 2,
		'height': ($('.notify_imgs_small').height() * 2 + parseInt($('.notify_imgs_small').css('margin')))
	});
	
	if(inMosaic)
	{
		$('#controls_1hand_imgs').css(
		{
			'padding-left': ($('#help_controls').width() - ($('.notify_imgs_small').width())) / 2,
			'height': ($('.notify_imgs_small').height())
		});
	}
	else
	{
		$('#controls_1hand_imgs_1').css(
		{
			'padding-left': ($('#help_controls').width() - ($('.notify_imgs_small').width() * 5 + parseInt($('.notify_imgs_small').css('margin')))) / 2,
			'height': ($('.notify_imgs_small').height())
		});
		$('#controls_1hand_imgs_2').css(
		{
			'padding-left': ($('#help_controls').width() - ($('.notify_imgs_small').width() * 4 + parseInt($('.notify_imgs_small').css('margin')))) / 2,
			'height': ($('.notify_imgs_small').height())
		});
	}
	
	var search_width = $('#help_search').width();
	
	$('#search_title').html('Recherche');
	$('#search_2hands_text').html('Gestes à effectuer avec les deux mains');
	$('#search_body_text').html('Gestes à effectuer avec le corps entier');
	
	for(var i = 0 ; i < search_2hands_tab.length ; i++)
	{
		$("#2hands_" + search_2hands_tab[i]).css("background-image", "url('./pictos/help/" + search_2hands_tab[i] + ".png')");
		//console.log("url('../../pictos/help/" + search_2hands_tab[i] + ".png')");
	}
	
	for(var i = 0 ; i < search_body_tab.length ; i++)
	{
		$("#body_" + search_body_tab[i]).css("background-image", "url('./pictos/help/" + search_body_tab[i] + ".png')");
		//console.log("url('../../pictos/help/" + search_2hands_tab[i] + ".png')");
	}
	
	$('#controls_title').html('Contrôles');
	$('#controls_1hand_text').html('Gestes à effectuer avec une seule main');
	
	if(inMosaic)
	{
		for(var i = 0 ; i < controls_1hand_tab.length ; i++)
		{
			$("#1hand_" + controls_1hand_tab[i]).css("background-image", "url('./pictos/help/" + controls_1hand_tab[i] + ".png')");
		}
	}
	else
	{
		for(var i = 0 ; i < controls_1hand_tab_1.length ; i++)
		{
			$("#1hand_" + controls_1hand_tab_1[i]).css("background-image", "url('./pictos/help/" + controls_1hand_tab_1[i] + ".png')");
		}
		for(var i = 0 ; i < controls_1hand_tab_2.length ; i++)
		{
			$("#1hand_" + controls_1hand_tab_2[i]).css("background-image", "url('./pictos/help/" + controls_1hand_tab_2[i] + ".png')");
		}
	}
	
	//On les fait apparaître.
	$('#notify_help').css(
	{
		opacity: "1"
	});
	
	$('.notify_imgs_big').css(
	{
		opacity: "1"
	});
}

/*
 * Supprime l'aide.
*/
mosaic.prototype.removeHelp = function()
{
	if(!this.helpDisplayed)
	{
		return;
	}
	
	var _this = this;
	
	$('#notify_help').fadeOut(this.timeNotifyFade, function()
	{
		_this.helpDisplayed = false;
		// _this.canNotifyHelp = false;
		_this.canNotifyHelp = true;
		console.log('CAN NOT NOTIFY HELP');
		$('#notify_help').remove();
	});
}

/*
 * Affiche la notification de validation/survol de gesture de filtrage.
 * Mode prend pour valeurs : "valid" ou "hover".
*/
mosaic.prototype.notifySearch1Gesture = function(gestureName, mode)
{
	// console.log('C');
	if($('#notify_search_1gesture').length > 0)
	{
		$('#notify_search_1gesture').remove();
	}
	
	//Si on a effectué une demande de recherche auparavant, on supprime la notification de demande de recherche.
	if($('#notify_search').length > 0)
	{
		$('.notifications').remove();
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var point_left = $(window).width() / 2 - (notify_width) / 2 - notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		top: 0,
		left: ($(window).width() - notify_width) / 2
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

// /!\/!\/!\ //

/* NOUVELLES NOTIFICATIONS */

// /!\/!\/!\ //

/*
 * Affichage de la notification de sélection & recherche dans la mosaïque.
*/
mosaic.prototype.mosaicSelectionAndSearch = function()
{
	if(this.currentMode != 'MOSAIC')
	{
		return;
	}
	
	//On spécifie les notifications en div.
	var notification_selection = "<div id='notify_selection' class='notifications'></div>";
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_selection + notification_search);

	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var selection_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var search_left = selection_left + notify_width + notify_margin;
	
	//On les positionne.
	$('#notify_selection').css(
	{
		left: selection_left
	});
	$('#notify_search').css(
	{
		left: search_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de sélection dans la mosaïque.
*/
mosaic.prototype.mosaicSelection = function()
{
	if(this.currentMode != 'MOSAIC')
	{
		return;
	}
	
	//On spécifie la notification en div.
	var notification_selection = "<div id='notify_selection' class='notifications'></div>";
	
	//On l'ajoute à la mosaïque.
	$('body').append(notification_selection);

	//On calcule ses coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var selection_left = $(window).width() / 2 - (notify_width) / 2 - notify_margin;
	
	//On les positionne.
	$('#notify_selection').css(
	{
		left: selection_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche dans une demande de filtrage de la mosaïque.
*/
mosaic.prototype.filterSearch = function()
{
	if(this.currentMode != 'FILTER' || this.filterSearchedType)
	{
		return;
	}
	
	// window.location.reload();
	
	//On spécifie la notification en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	
	//On l'ajoute à la mosaïque.
	$('body').append(notification_search);

	//On calcule ses coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - notify_width / 2 - notify_margin;
	
	//On la positionne.
	$('#notify_search').css(
	{
		left: search_left
	});
	
	//On la fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche & sélection dans une demande de filtrage de la mosaïque.
*/
mosaic.prototype.filterSearchAndSelection = function()
{
	if(this.currentMode != 'FILTER' || this.filterSearchedType)
	{
		return;
	}
	
	//On spécifie les notifications en div.
	var notification_selection = "<div id='notify_selection' class='notifications'></div>";
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_selection + notification_search);

	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var selection_left = search_left + notify_width + notify_margin;
	
	//On les positionne.
	$('#notify_selection').css(
	{
		left: selection_left
	});
	$('#notify_search').css(
	{
		left: search_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat de gesture dans la mosaïque filtrée.
*/
mosaic.prototype.filterGesture = function(gestureName, mode)
{
	if(this.currentMode != 'FILTER' || !this.filterSearchedType)
	{
		return;
	}
	
	// console.trace();
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var point_left = $(window).width() / 2 - (notify_width) / 2 - notify_margin;
	
	// console.log('url("./pictos/big/' + (this.mouseInteractions ? 'MI' : '') + '/' + mode + '/' + gestureName + '.png")');
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI' : '') + '/' + (this.gestureDelRequested ? 'hover' : 'valid') + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		top: 0,
		left: ($(window).width() - notify_width) / 2
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat de gesture & de sélection dans la mosaïque filtrée.
*/
mosaic.prototype.filterGestureAndSelection = function(gestureName, mode)
{
	if(this.currentMode != 'FILTER' || !this.filterSearchedType)
	{
		return;
	}
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	var notification_selection = "<div id='notify_selection' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture + notification_selection);

	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_1gesture_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var selection_left = search_1gesture_left + notify_width + notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI' : '') + '/' + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		left: search_1gesture_left
	});
	$('#notify_selection').css(
	{
		left: selection_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affiche la notification de dezoom.
 * Direction vaut left ou right.
*/
mosaic.prototype.videoSwipe = function(direction)
{
	if(this.currentMode != 'VIDEO' || !this.isSwipe)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_swipe = "<div id='notify_swipe' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_swipe);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var point_left = $(window).width() / 2 - (notify_width) / 2 - notify_margin;
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_swipe').css(
	{
		top: -notifyTop,
		left: -notifyLeft + ($(window).width() - notify_width - notify_margin) / 2,
		'background-image': 'url(./pictos/notifications/swipe_' + direction + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat de move vers un voisin.
*/
mosaic.prototype.videoMove = function(targetId)
{
	if(this.currentMode != 'VIDEO')
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_move);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var move_left = $(window).width() / 2 - (notify_width) / 2 + notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	// console.log(this.neighboursIds, parseInt(targetId), side);
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_move').css(
	{
		top: -notifyTop,
		left: -notifyLeft + move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat de move vers un voisin & de dézoom dans une vidéo.
*/
mosaic.prototype.videoMoveAndUnzoom = function(targetId)
{
	if(this.currentMode != 'VIDEO')
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_move + notification_unzoom);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var move_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var unzoom_left = move_left + notify_width + notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	// console.log(this.neighboursIds, parseInt(targetId), side);
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	var unzooms = ['horizontal', 'vertical'];
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_move').css(
	{
		top: -notifyTop,
		left: -notifyLeft + move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	
	$('#notify_unzoom').css(
	{
		top: -notifyTop,
		left: -notifyLeft + unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat de dézoom dans une vidéo.
*/
mosaic.prototype.videoUnzoom = function(targetId)
{
	if(this.currentMode != 'VIDEO')
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie la notifications en div.
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On l'ajoute à la mosaïque.
	$('body').append(notification_unzoom);
	
	//On calcule ses coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var unzoom_left = $(window).width() / 2 - notify_width / 2 - notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	if(side == -1)
	{
		return;
	}
	
	var unzooms = ['horizontal', 'vertical'];
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On la positionne.
	$('#notify_unzoom').css(
	{
		top: -notifyTop,
		left: -notifyLeft + unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de timeline dans une vidéo/recherche.
*/
mosaic.prototype.timelineTimeline = function()
{
	if(this.currentMode != 'TIMELINE')
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie la notifications en div.
	var notification_timeline = "<div id='notify_timeline' class='notifications'></div>";
	
	//On l'ajoute à la mosaïque.
	$('body').append(notification_timeline);
	
	//On calcule ses coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var timeline_left = $(window).width() / 2 - notify_width / 2 - notify_margin;
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On la positionne.
	$('#notify_timeline').css(
	{
		top: -notifyTop,
		left: -notifyLeft + timeline_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche dans une vidéo de recherche.
*/
mosaic.prototype.searchSearch = function()
{
	if(this.currentMode != 'SEARCH' || this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie la notifications en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	
	//On l'ajoute à la mosaïque.
	$('body').append(notification_search);
	
	//On calcule ses coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - notify_width / 2 - notify_margin;
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On la positionne.
	$('#notify_search').css(
	{
		top: -notifyTop,
		left: -notifyLeft + search_left
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche & de swipe dans une vidéo de recherche.
*/
mosaic.prototype.searchSearchAndSwipe = function(direction)
{
	if(this.currentMode != 'SEARCH' || this.isCurrentlyInASearchByGesture || !this.isSwipe)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	var notification_swipe = "<div id='notify_swipe' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search + notification_swipe);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var swipe_left = search_left + notify_width + notify_margin;
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_search').css(
	{
		top: -notifyTop,
		left: -notifyLeft + search_left
	});
	$('#notify_swipe').css(
	{
		top: -notifyTop,
		left: -notifyLeft + swipe_left,
		'background-image': 'url(./pictos/notifications/swipe_' + direction + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche, de move vers un voisin.
*/
mosaic.prototype.searchSearchAndMove = function(targetId)
{
	if(this.currentMode != 'SEARCH' || this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	//On spécifie les notifications en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search + notification_move);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var move_left = search_left + notify_width + notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_search').css(
	{
		top: -notifyTop,
		left: -notifyLeft + search_left
	});
	$('#notify_move').css(
	{
		top: -notifyTop,
		left: -notifyLeft + move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche, de move vers un voisin & de dézoom dans une vidéo de recherche.
*/
mosaic.prototype.searchSearchAndMoveAndUnzoom = function(targetId)
{
	if(this.currentMode != 'SEARCH' || this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	//On spécifie les notifications en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search + notification_move + notification_unzoom);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - (notify_width * 3 + notify_margin * 4) / 2;
	var move_left = search_left + notify_width + notify_margin;
	var unzoom_left = move_left + notify_width + notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	var unzooms = ['horizontal', 'vertical'];
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_search').css(
	{
		top: -notifyTop,
		left: -notifyLeft + search_left
	});
	$('#notify_move').css(
	{
		top: -notifyTop,
		left: -notifyLeft + move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	$('#notify_unzoom').css(
	{
		top: -notifyTop,
		left: -notifyLeft + unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de recherche & de dézoom dans une vidéo de recherche.
*/
mosaic.prototype.searchSearchAndUnzoom = function()
{
	if(this.currentMode != 'SEARCH' || this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search = "<div id='notify_search' class='notifications'></div>";
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search + notification_unzoom);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var unzoom_left = search_left + notify_width + notify_margin;
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	// console.log(this.neighboursIds, parseInt(targetId), side);
	if(side == -1)
	{
		return;
	}
	
	var unzooms = ['horizontal', 'vertical'];
	
	// var notifyTop = this.notifyTopVideo, notifyLeft = this.notifyLeftVideo;
	var notifyTop = 0, notifyLeft = 0;
	
	//On les positionne.
	$('#notify_move').css(
	{
		top: -notifyTop,
		left: -notifyLeft + search_left
	});
	
	$('#notify_unzoom').css(
	{
		top: -notifyTop,
		left: -notifyLeft + unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat dans une vidéo de recherche.
*/
mosaic.prototype.searchGesture = function(gestureName, mode)
{
	if(this.currentMode != 'SEARCH' || !this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var point_left = $(window).width() / 2 - (notify_width) / 2 - notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		top: 0,
		left: ($(window).width() - notify_width) / 2
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat & de swipe dans une vidéo de recherche.
*/
mosaic.prototype.searchGestureAndSwipe = function(gestureName, mode, direction)
{
	if(this.currentMode != 'SEARCH' || !this.isCurrentlyInASearchByGesture || !this.isSwipe)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	var notification_swipe = "<div id='notify_swipe' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture + notification_swipe);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_1gesture_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var swipe_left = search_1gesture_left + notify_width + notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		left: search_1gesture_left
	});
	$('#notify_swipe').css(
	{
		left: swipe_left,
		'background-image': 'url(./pictos/notifications/swipe_' + direction + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat, de move vers un voisin.
*/
mosaic.prototype.searchGestureAndMove = function(gestureName, mode, targetId)
{
	if(this.currentMode != 'SEARCH' || !this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture + notification_move);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_1gesture_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var move_left = search_1gesture_left + notify_width + notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		left: search_1gesture_left
	});
	$('#notify_move').css(
	{
		left: move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat, de move vers un voisin & de dézoom dans une vidéo de recherche.
*/
mosaic.prototype.searchGestureAndMoveAndUnzoom = function(gestureName, mode, targetId)
{
	if(this.currentMode != 'SEARCH' || !this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	var notification_move = "<div id='notify_move' class='notifications'></div>";
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture + notification_move + notification_unzoom);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_1gesture_left = $(window).width() / 2 - (notify_width * 3 + notify_margin * 4) / 2;
	var move_left = search_1gesture_left + notify_width + notify_margin;
	var unzoom_left = move_left + notify_width + notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	
	if(side == -1)
	{
		return;
	}
	
	var sides = ['left', 'right', 'up', 'down'];
	var unzooms = ['horizontal', 'vertical'];
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		left: search_1gesture_left
	});
	$('#notify_move').css(
	{
		left: move_left,
		'background-image': 'url(./pictos/notifications/move_' + sides[side] + '.png)'
	});
	$('#notify_unzoom').css(
	{
		left: unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage de la notification de résultat & de dézoom dans une vidéo de recherche.
*/
mosaic.prototype.searchGestureAndUnzoom = function(gestureName, mode, targetId)
{
	if(this.currentMode != 'SEARCH' || !this.isCurrentlyInASearchByGesture)
	{
		return;
	}
	
	var _this = this;
	
	//On spécifie les notifications en div.
	var notification_search_1gesture = "<div id='notify_search_1gesture' class='notifications'></div>";
	var notification_unzoom = "<div id='notify_unzoom' class='notifications'></div>";
	
	//On les ajoute à la mosaïque.
	$('body').append(notification_search_1gesture + notification_unzoom);
	
	// console.log(this.player.config.gui.zoomTop + " " + this.player.config.gui.zoomLeft);
	
	//On calcule leurs coordonnées et dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var search_1gesture_left = $(window).width() / 2 - (notify_width * 2 + notify_margin * 3) / 2;
	var unzoom_left = search_1gesture_left + notify_width + notify_margin;
	
	if(_.include(this.gestures, gestureName))
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + mode + '/' + gestureName + '.png")');
	}
	else if(mode == 'none')
	{
		$('#notify_search_1gesture').css('background-image', 'url("./pictos/big/normal/inconnu.png")');
	}
	
	var side = $.inArray(parseInt(targetId), this.neighboursIds);
	
	if(side == -1)
	{
		return;
	}
	
	var unzooms = ['horizontal', 'vertical'];
	
	//On les positionne.
	$('#notify_search_1gesture').css(
	{
		left: search_1gesture_left
	});
	$('#notify_unzoom').css(
	{
		left: unzoom_left,
		'background-image': 'url(./pictos/notifications/unzoom_' + unzooms[Math.floor(side / 2)] + '.png)'
	});
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}

/*
 * Affichage des notifications de gestures trouvées dans une recherche par courbes.
*/
mosaic.prototype.curvesGestures = function(gestures)
{
	//S'il n'y a pas de gestures à afficher.
	if(gestures.length == 0)
	{
		console.log('NONE');
		//On ajoute une seule notification.
		var notification_curves = "<div class='notifications' id='notify_curves'></div>";
		$('body').append(notification_curves);
		
		//On calcule leurs dimensions et coordonnées.
		var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
		var notify_margin = parseInt($('.notifications').css('margin'));
		var curves_left = $(window).width() / 2 - (notify_width + notify_margin * 2) / 2;
		
		$('#notify_curves').css(
		{
			left: curves_left,
			'background-image': 'url("./pictos/big/normal/inconnu.png")',
			opacity: '0.9'
		});
		return;
	}
	
	//Sinon, on les met dans un tableau.
	var gestures_tab = gestures.split(';');
	
	var notifications_curves_gestures = '';
	
	//On crée autant de notifications qu'il y a de gestures.
	for(var i = 0 ; i < gestures_tab.length ; i++)
	{
		notifications_curves_gestures += "<div class='notifications' id='notify_curves_" + gestures_tab[i] + "'></div>";
	}
	
	//On les ajoute à la mosaïque.
	$('body').append(notifications_curves_gestures);
	
	//On calcule leurs dimensions.
	var notify_width = $('.notifications').width(), notify_height = $('.notifications').height();
	var notify_margin = parseInt($('.notifications').css('margin'));
	var curves_gestures_left = [];
	
	//On calcule leurs dimensions et leur backgrounds.
	curves_gestures_left[0] = $(window).width() / 2 - (notify_width * (gestures_tab.length) + notify_margin * (gestures_tab.length + 2)) / 2;
	
	for(var i = 0 ; i < gestures_tab.length ; i++)
	{
		//On va chercher leurs backgrounds.
		$('#notify_curves_' + gestures_tab[i]).css('background-image', 'url("./pictos/big/' + (this.mouseInteractions ? 'MI/' : '') + 'normal/' + gestures_tab[i] + '.png")');
		// console.log('url("./pictos/big/MI/normal/' + gestures_tab[i] + '.png")');
		
		//On calcule leurs coordonnées.
		if(i+1 < gestures_tab.length)
		{
			curves_gestures_left[i+1] = curves_gestures_left[i] + notify_width + notify_margin * 2;
		}
		
		//On les place.
		$('#notify_curves_' + gestures_tab[i]).css('left', curves_gestures_left[i]);
	}
	
	//On les fait apparaître.
	$('.notifications').css(
	{
		opacity: "0.9"
	});
}