/*
* This file is part of the TraKERS\Front JS package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front JS
 * Fichier : index.html
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit le module de communication qui établit la connexion entre ce Front et le Middleware.
 */

/*
 * Un client est défini par une socket, qui permettra de recevoir les données du server websocket du Middleware.
 * On accède aussi à la classe des pointeurs.
*/
function client(host, port, _pointers)
{
    this.socket;
    this.pointers = _pointers;
    
    this.pointerLeft = false;
    this.pointerRight = false;
    this.timePointers = 100;
    this.pointerLeftTimeout;
    this.pointerRightTimeout;
    this.isLeftHanded = false;
    
    this.createWebSocket('ws://' + host + ':' + port + '/');
}

/*
 * Création et Initialisation des sockets et listeners permettant d'écouter le server.
*/
client.prototype.createWebSocket = function(host)
{
    var _this = this;
    
    //Initialise la fonctionnalité websocket du naviguateur.
    if(window.MozWebSocket)
    {
        window.WebSocket = window.MozWebSocket;
    }
    
    //Si le naviguateur ne supporte pas les websockets, on s'arrête là.
    if(!window.WebSocket)
    {
        alert('Votre navigateur ne supporte pas les webSocket!');
        return false;
    }
    //Sinon
    else
    {
        //On initialise la socket.
        this.socket = new WebSocket(host);
        
        //Si elle est ouverte, on notifie le Front.
        this.socket.onopen = function()
        {
            console.log('Socket ouverte.');
        }
        //Si elle est fermée, on notifie le Front.
        this.socket.onclose = function()
        {
            console.log('Socket fermée.');
        }
        //S'il y a un problème dans la connection, on notifie le Front.
        this.socket.onerror = function()
        {
            console.log('Une erreur est survenue dans le module de Communication.');
        }
        //Si on reçoit un message.
        this.socket.onmessage = function(msg)
        {
            _this.processMsg(msg);
        }
    }
}

/*
 * Traite un message reçu du Middleware.
*/
client.prototype.processMsg = function(msg)
{
    if(typeof msg === 'undefined' || typeof msg.data === 'undefined')
    {
        return;
    }
    
    var _this = this;
    
    //Sinon si ce sont les coordonnées de la main droite.
    if(msg.data[0] == '1')
    {
        var instruction = msg.data.substring(2, msg.data.length);
        pt = instruction.split(';');
        var x = Math.abs(parseFloat(pt[0])), y = Math.abs(parseFloat(pt[1]));
        this.pointerLeft = true;
        clearTimeout(this.pointerLeftTimeout);
        
        this.pointers.refreshMainPointer(x, y);
        
        if(!this.pointers.isMainPointerDisplayed)
        {
            this.pointers.mainPointerDisplay(true);
            this.pointers.isMainPointerDisplayed = true;
        }
        
        this.pointerLeftTimeout = setTimeout(function()
        {
            _this.pointerLeft = false;
            
            if(_this.pointers.isMainPointerDisplayed)
            {
                _this.pointers.isMainPointerDisplayed = false;
                _this.pointers.mainPointerDisplay(false);
            }
        }, this.timePointers);
    }
    //Sinon si ce sont les coordonnées de la main gauche.
    else if(msg.data[0] == '0')
    {
        var instruction = msg.data.substring(2, msg.data.length);
        pt = instruction.split(';');
        var x = Math.abs(parseFloat(pt[0])), y = Math.abs(parseFloat(pt[1]));
        
        this.pointerRight = true;
        clearTimeout(this.pointerRightTimeout);

        this.pointers.refreshSecondPointer(x, y);
        
        if(!this.pointers.isSecondPointerDisplayed)
        {
            this.pointers.secondPointerDisplay(true);
            this.pointers.isSecondPointerDisplayed = true;
        }
        
        this.pointerRightTimeout = setTimeout(function()
        {
            _this.pointerRight = false;
            
            if(_this.pointers.isSecondPointerDisplayed)
            {
                _this.pointers.isSecondPointerDisplayed = false;
                _this.pointers.secondPointerDisplay(false);
            }
        }, this.timePointers);
    }
    
    if(this.pointerLeft && !this.pointerRight || !this.pointerLeft && this.pointerRight || !this.pointerLeft && !this.pointerRight)
    {
        this.pointers.areBothPointersHere = false;
    }
}