/*
    Modified by alexandre.bastien@iri.centrepompidou.fr to manage TUIO strings.
*/

#ifndef INCLUDED_TUIOSTRING_H
#define INCLUDED_TUIOSTRING_H

class TuioString {

    protected:
        int session_id;
        int string_id;
        const char* code;
        long timestamp;
        int state;
    
    public:
    TuioString (int s_id, int string_id, const char* _code) {
        this->session_id = s_id;
        this->string_id = string_id;
        this->code = _code;
        timestamp = TUIO_UNDEFINED;
        state = TUIO_ADDED;
    };

    TuioString (TuioString *tuioString) {
        this->session_id = tuioString->getSessionID();
        this->string_id = tuioString->getStringID();
        this->code = tuioString->getCode();
        timestamp = TUIO_UNDEFINED;
        state = TUIO_ADDED;
    };
    
    ~TuioString(){};
    
    int getSessionID() { return session_id; };
    int getStringID() { return string_id; };
    const char* getCode() { return code; };


    void update(const char* _code)
    {
        this->code = _code;
        timestamp = TUIO_UNDEFINED;
        state = TUIO_UPDATED;
    }

    void remove() {
        state = TUIO_REMOVED;
        timestamp = TUIO_UNDEFINED;        
    }

    long getUpdateTime() { return timestamp; };
    void setUpdateTime(long timestamp) { this->timestamp = timestamp; };
};

#endif
