﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : SwipeListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a effectué un swipe.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Trakers.Tracking.Events
{
    public class SwipeListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a effectué un swipe.
        */
        public void ShowOnScreen(object o, SwipeEventArgs e)
        {
            //On l'indique dans le debug.
            e.debug.showSwipe(e);
            //e.debug.ExceptionLbl.Content = "SWIPE";
            //On notifie le serveur TUIO.
            e.server.Swipe(o, e);
        }
    }
}
