﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : UserPositionEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur se déplace dans la zone de détection.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;

namespace Trakers.Tracking.Events
{
    public class UserPositionEventArgs : EventArgs
    {
        //Fenêtre de debug.
        public readonly Debug.DebugWindow debug;
        //Serveur TUIO.
        public readonly Server server;
        //Distance à Kinect.
        public readonly float distance;

        /*
        * Constructeur : Il prend l'affichage de debug, le serveur TUIO et la distance à Kinect.
        */
        public UserPositionEventArgs(Debug.DebugWindow _debug, Server _server, float _distance)
        {
            debug = _debug;
            server = _server;
            distance = _distance;
        }
    }
}
