import TUIO.*;
TuioProcessing tuioClient;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Création de la fenêtre et du client TUIO*/
void setup()
{
    size (640, 480);
    showMask();
    tuioClient = new TuioProcessing(this, 80);
    textAlign(CENTER);
    imageMode(CENTER);
    smooth();
}

/*FONCTION DE DESSIN
Entrée :
Sortie : Appel à la fonction de traitement d'input du serveur toutes les n millisecondes*/
void draw()
{
    fill(0);
    tuioStringInput();
    noStroke();
}

/*FONCTION DE GENERATION DU MASQUE
Entrée :
Sortie : Place des rectangles autour de la zone de dessin*/
void showMask()
{
    background(0);
    fill(255);
    rect(0, 80, width, height-130);
}

/*FONCTION DE RECEPTION DES MESSAGES OSC
Entrée :
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void tuioStringInput()
{
    fill(255);
    Vector tuioStringList = tuioClient.getTuioStrings();
    if(tuioStringList == null || tuioStringList.size() <= 0)
    {
        showMask();
        text("Gesture non détectée.", width/2 - 20, 20);
    }
    else
    {
        showMask();
        showGestureMessage((TuioString)tuioStringList.elementAt(0));
    }
}

/*FONCTION D'AFFICHAGE DU CODE DE LA GESTURE DETECTEE
Entree :
Sortie : Affichage du code de la gesture*/
void showGestureMessage(TuioString tstr)
{
    text("Gesture détectée : " + tstr.getMessage(), width/2 - 20, 20);
}

