/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.math.BigInteger;
import java.util.Date;

public class OSCByteArrayToJavaConverter {
    byte[] bytes;
    int bytesLength;
    int streamPosition;
    private byte[] intBytes = new byte[4];
    private byte[] floatBytes = new byte[4];
    private byte[] secondBytes = new byte[8];
    private byte[] picosecBytes = new byte[8];

    public OSCPacket convert(byte[] byArray, int n) {
        this.bytes = byArray;
        this.bytesLength = n;
        this.streamPosition = 0;
        if (this.isBundle()) {
            return this.convertBundle();
        }
        return this.convertMessage();
    }

    private boolean isBundle() {
        String string = new String(this.bytes, 0, 7);
        return string.startsWith("#bundle");
    }

    private OSCBundle convertBundle() {
        this.streamPosition = 8;
        Date date = this.readTimeTag();
        OSCBundle oSCBundle = new OSCBundle(date);
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        while (this.streamPosition < this.bytesLength) {
            int n = (Integer)this.readInteger();
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, this.streamPosition, byArray, 0, n);
            this.streamPosition += n;
            OSCPacket oSCPacket = oSCByteArrayToJavaConverter.convert(byArray, n);
            oSCBundle.addPacket(oSCPacket);
        }
        return oSCBundle;
    }

    private OSCMessage convertMessage() {
        OSCMessage oSCMessage = new OSCMessage();
        oSCMessage.setAddress(this.readString());
        char[] cArray = this.readTypes();
        if (null == cArray) {
            return oSCMessage;
        }
        this.moveToFourByteBoundry();
        for (int i = 0; i < cArray.length; ++i) {
            if ('[' == cArray[i]) {
                oSCMessage.addArgument(this.readArray(cArray, i));
                while (']' != cArray[i]) {
                    ++i;
                }
                continue;
            }
            oSCMessage.addArgument(this.readArgument(cArray[i]));
        }
        return oSCMessage;
    }

    private String readString() {
        int n = this.lengthOfCurrentString();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.bytes[this.streamPosition++];
        }
        this.moveToFourByteBoundry();
        return new String(cArray);
    }

    private char[] readTypes() {
        if (this.bytes[this.streamPosition] != 44) {
            return null;
        }
        ++this.streamPosition;
        int n = this.lengthOfCurrentString();
        if (0 == n) {
            return null;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.bytes[this.streamPosition++];
        }
        return cArray;
    }

    private Object readArgument(char c) {
        switch (c) {
            case 'i': {
                return this.readInteger();
            }
            case 'h': {
                return this.readBigInteger();
            }
            case 'f': {
                return this.readFloat();
            }
            case 'd': {
                return this.readDouble();
            }
            case 's': {
                return this.readString();
            }
            case 'c': {
                return this.readChar();
            }
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Object readChar() {
        return new Character((char)this.bytes[this.streamPosition++]);
    }

    private Object readDouble() {
        return this.readFloat();
    }

    private Object readFloat() {
        this.floatBytes[0] = this.bytes[this.streamPosition++];
        this.floatBytes[1] = this.bytes[this.streamPosition++];
        this.floatBytes[2] = this.bytes[this.streamPosition++];
        this.floatBytes[3] = this.bytes[this.streamPosition++];
        int n = (this.floatBytes[3] & 0xFF) + ((this.floatBytes[2] & 0xFF) << 8) + ((this.floatBytes[1] & 0xFF) << 16) + ((this.floatBytes[0] & 0xFF) << 24);
        return new Float(Float.intBitsToFloat(n));
    }

    private Object readBigInteger() {
        this.intBytes[0] = this.bytes[this.streamPosition++];
        this.intBytes[1] = this.bytes[this.streamPosition++];
        this.intBytes[2] = this.bytes[this.streamPosition++];
        this.intBytes[3] = this.bytes[this.streamPosition++];
        int n = (this.intBytes[3] & 0xFF) + ((this.intBytes[2] & 0xFF) << 8) + ((this.intBytes[1] & 0xFF) << 16) + ((this.intBytes[0] & 0xFF) << 24);
        return new Integer(n);
    }

    private Object readInteger() {
        this.intBytes[0] = this.bytes[this.streamPosition++];
        this.intBytes[1] = this.bytes[this.streamPosition++];
        this.intBytes[2] = this.bytes[this.streamPosition++];
        this.intBytes[3] = this.bytes[this.streamPosition++];
        int n = (this.intBytes[3] & 0xFF) + ((this.intBytes[2] & 0xFF) << 8) + ((this.intBytes[1] & 0xFF) << 16) + ((this.intBytes[0] & 0xFF) << 24);
        return new Integer(n);
    }

    private Date readTimeTag() {
        System.arraycopy(this.bytes, this.streamPosition, this.secondBytes, 4, 4);
        this.streamPosition += 4;
        System.arraycopy(this.bytes, this.streamPosition, this.picosecBytes, 4, 4);
        this.streamPosition += 4;
        BigInteger bigInteger = new BigInteger(this.secondBytes);
        long l = bigInteger.longValue() - OSCBundle.SECONDS_FROM_1900_to_1970.longValue();
        if (l < 0L) {
            l = 0L;
        }
        BigInteger bigInteger2 = new BigInteger(this.picosecBytes);
        long l2 = l * 1000L + bigInteger2.longValue() / 1000L;
        return new Date(l2);
    }

    private Object[] readArray(char[] cArray, int n) {
        int n2 = 0;
        while (cArray[n + n2] != ']') {
            ++n2;
        }
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n < n2) {
            objectArray[n3] = this.readArgument(cArray[n + n3]);
            ++n3;
        }
        return objectArray;
    }

    private int lengthOfCurrentString() {
        int n = 0;
        while (this.bytes[this.streamPosition + n] != 0) {
            ++n;
        }
        return n;
    }

    private void moveToFourByteBoundry() {
        int n = this.streamPosition % 4;
        this.streamPosition += 4 - n;
    }
}

