﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : PushListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a effectué un push.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.Tracking.Events
{
    public class PushListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a effectué un push.
        */
        public void ShowOnScreen(object o, PushEventArgs e)
        {
            //On l'indique dans le debug.
            e.debug.showPush(e);
            //e.debug.ExceptionLbl.Content = "SWIPE";
            //On notifie le serveur TUIO.
            e.server.Pull(o, e);
        }
    }
}
