import TUIO.*;
TuioProcessing tuioClient;
//Indique s'il s'agit de la main gauche.
boolean oneHandLeft;

//Port du Client TUIO
int port = 80;
float minDistHands = 1;
float maxDistHands = 1.5;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Création de la fenêtre et du client TUIO*/
public void setup()
{
    size (640, 480);
    showMask();
    tuioClient = new TuioProcessing(this, port);
    textAlign(CENTER);
    imageMode(CENTER);
    smooth();
}

/*FONCTION DE DESSIN
Entrée :
Sortie : Appel à la fonction de traitement d'input du serveur toutes les n millisecondes*/
public void draw()
{
    fill(0);
    tuioInput();
    noStroke();
}

/*FONCTION DE RECEPTION DES MESSAGES OSC
Entrée :
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
public void tuioInput()
{
    noFill();
    Vector tuioCursorList = tuioClient.getTuioCursors();
    
    if(tuioCursorList.size() <= 0)
    {
        showMask();
        refreshText("Les mains sont trop loin ou trop près.", "Je ne détecte aucune main.");
    }
    		
    if(tuioCursorList.size() == 1)
    {
        handleOneHand((TuioCursor)tuioCursorList.elementAt(0));
        fill(255);
        refreshText("Les mains sont dans la zone de captation.", "Je détecte une main.");
    }
    else if(tuioCursorList.size() == 2)
    {
        handleBothHands(tuioCursorList);
        fill(255);
        refreshText("Les mains sont dans la zone de captation.", "Je détecte les deux mains.");
    }
}

/*FONCTION DE GENERATION DU MASQUE
Entrée :
Sortie : Place des rectangles autour de la zone de dessin*/
public void showMask()
{
    background(0);
    fill(255);
    rect(0, 80, width, height-130);
}
	
/*FONCTION DE RAFFRACHISSEMENT DU TEXTE SUPERIEUR
Entrée : Texte à afficher
Sortie : Place un rectangle au dessus de la zone de dessin et raffraichit le texte*/
public void refreshText(String txt1, String txt2)
{
    fill(0);
    rect(0, 0, width, 80);
    fill(255);
    text(txt1, width/2 - 20, 20);
    text(txt2, width/2 - 20, 40);
}

/*FONCTION DE GESTION DES COURBES POUR UNE MAIN DETECTEE
Entrée : Un curseur TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
public void handleOneHand(TuioCursor handCursor)
{
    TuioPoint pt = handCursor.getPosition();//(TuioPoint)pointList.get(j);
    fill(0);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), !oneHandLeft);
}

/*FONCTION DE GESTION DES COURBES POUR DEUX MAINS DETECTEES
Entrée : La liste des curseurs TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleBothHands(Vector tuioCursorList)
{
    TuioCursor handLeftCursor = (TuioCursor)tuioCursorList.elementAt(0);
    TuioCursor handRightCursor = (TuioCursor)tuioCursorList.elementAt(1);
    TuioPoint pt;

    pt = (TuioPoint)handLeftCursor.getPosition();//handLeftPointList.get(j);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), true);
    pt = (TuioPoint)handRightCursor.getPosition();//handRightPointList.get(k);
    drawEllipse(pt.getX(), pt.getY(), pt.getZ(), false);
}

/*FONCTION DE DESSIN D'UN POINT DE COURBE
Entrée : Coordonnées X, Y et Z d'un point
Sortie : Le point est dessiné avec une épaisseur et une luminosité dépendant de Z*/
void drawEllipse(float x, float y, float z, boolean leftHand)
{

    fill(0, 0, 255);
    stroke(0,0,0);

    float weight = map(z, minDistHands, maxDistHands, 50, 1);
    float redColor = map(z, minDistHands, maxDistHands, 255, 80);
    
    if(leftHand)
        fill(redColor,0,0);
    else
        fill(0,redColor,0);
    
    if(weight < 30)
    {
        //strokeWeight(0);
    }
    else
    {
        fill(0, 0, redColor);
    }
    
    
    ellipse(x+20, y+100, weight, weight);
}
