﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : JumpEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur a sauté.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;

namespace Trakers.Tracking.Events
{
    public class JumpEventArgs : EventArgs
    {
        //Fenêtre de debug.
        public readonly Debug.DebugWindow debug;
        //Serveur TUIO.
        public readonly Server server;

        /*
        * Constructeur : Il prend l'affichage de debug et le serveur TUIO.
        */
        public JumpEventArgs(Debug.DebugWindow _debug, Server _server)
        {
            debug = _debug;
            server = _server;
        }
    }
}
