﻿/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : RightHandQuitListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : La main droite est sortie du champ.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Events
{
    public class RightHandQuitListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : La main droite est sortie du champ.
        */
        public void ShowOnScreen(object o, RightHandQuitEventArgs e)
        {
            Joint handJoint = e.handJoint;
            //On l'indique dans le debug.
            e.debug.showRightHandRect(false);
            e.debug.showRightHandCoord("");
            //On notifie le serveur TUIO.
            e.server.RightHandQuit(o, e);
        }
    }
}
